/*
 * Decompiled with CFR 0.152.
 */
package brad16840.backpacks.gui;

import brad16840.backpacks.blocks.QuantumChest;
import brad16840.backpacks.blocks.QuantumChestTileEntity;
import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.BlockPos;
import brad16840.common.Common;
import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.gui.ClientState;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class QuantumChestContainer
extends StackableContainer {
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/quantum_chest.png");
    private IInventory inventory;
    private BlockPos chestPos;
    private int chestDimension;
    private String chestId;
    private BackpackSlot backpackSlot;
    private QuantumSlot quantumSlot;
    private QuantumChestTileEntity.VirtualQuantumChest chest;

    public QuantumChestContainer(IInventory inventory, BlockPos chestPos, int chestDimension, String chestId) {
        super(68, 68);
        this.inventory = inventory;
        this.chestPos = chestPos;
        this.chestDimension = chestDimension;
        this.chestId = chestId;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        this.chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, this.chestId);
        if (this.chest == null) {
            new Translatable("problem.quantumchest404", new Object[0]).log(player);
            return false;
        }
        if (!this.chest.canPlayerUse(player)) {
            UniqueItemData.permissionError("use", QuantumChest.name).log(player);
            return false;
        }
        this.backpackSlot = new BackpackSlot(player, this.inventory, 0, 26, 8);
        this.quantumSlot = new QuantumSlot(player, (IInventory)new QuantumInventory(), 0, 26, 44);
        this.addSlotToContainer(ContainerStack.ContainerSection.CHEST, this.backpackSlot);
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, this.quantumSlot);
        return true;
    }

    @Override
    public boolean customRightClick(EntityPlayer player, int slot, boolean holdingShift) {
        if (this.container.func_75139_a(slot) == this.quantumSlot) {
            ((QuantumInventory)this.quantumSlot.field_75224_c).useTargetColor = !((QuantumInventory)this.quantumSlot.field_75224_c).useTargetColor;
            return true;
        }
        return false;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        for (StackableContainer container1 : containers) {
            QuantumChestContainer t = (QuantumChestContainer)container1;
            t.chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, t.chestId);
            if (this.chest != null && this.chest.canPlayerUse(player)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, Slot slot, StackableContainer.ContainerSlotInterface containerSlot) {
        if (!UniqueItemData.get(player.field_70170_p).hasRequiredPermission(player, this.chestId, 2)) {
            return null;
        }
        ItemStack itemstack = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (!(itemstack.func_77973_b() instanceof Backpack)) {
                return null;
            }
            if (!this.container.mergeItemStack(this, itemstack1, 0, 1, true)) {
                return null;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, 0, this.guiWidth, this.guiHeight, 0, 0);
    }

    @Override
    public String getId() {
        return "none";
    }

    @Override
    public int getSlotCount() {
        return 2;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public int getRowSize() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean keyPressed(char key, int keyCode) {
        if (keyCode == Common.permissionKey.func_151463_i()) {
            if ((Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) && this.stackId == 0) {
                return false;
            }
            Common.channel.sendToServer(new PacketHandler.OpenGroup(0, new ClientState.PermissionGroupState(this.chestId, "I_" + this.chestId, 0, true), true));
            return true;
        }
        return false;
    }

    public class QuantumSlot
    extends StackableContainer.ContainerSlot {
        public QuantumSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super(player, inventory, par2, par3, par4);
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            if (stack != null && stack.func_77973_b() instanceof QuantumBackpack) {
                stack.field_77994_a = 0;
                return true;
            }
            return false;
        }

        public ItemStack func_75209_a(int par1) {
            return super.func_75209_a(par1);
        }

        public void func_82870_a(EntityPlayer par1EntityPlayer, ItemStack par2ItemStack) {
            FMLCommonHandler.instance().firePlayerCraftingEvent(par1EntityPlayer, par2ItemStack, this.field_75224_c);
        }
    }

    public class QuantumInventory
    implements IInventory {
        public boolean useTargetColor = false;

        public int func_70302_i_() {
            return 1;
        }

        public ItemStack func_70301_a(int i) {
            ItemStack backpack;
            if (QuantumChestContainer.this.backpackSlot.func_75216_d() && ((backpack = QuantumChestContainer.this.backpackSlot.func_75211_c()).func_77973_b() instanceof Backpack || backpack.func_77973_b() instanceof QuantumBackpack)) {
                ItemStack stack = new ItemStack((Item)Common.quantumBackpack);
                if (this.useTargetColor) {
                    int target = backpack.func_77960_j();
                    if (backpack.func_77973_b() instanceof Backpack) {
                        if (target > 15) {
                            target -= 16;
                        }
                        stack.func_77964_b(target + 1);
                    } else {
                        stack.func_77964_b(target);
                    }
                }
                if (backpack.func_82837_s()) {
                    stack.func_151001_c(backpack.func_82833_r());
                }
                QuantumBackpack.setChest(stack, QuantumChestContainer.this.chestPos, QuantumChestContainer.this.chestDimension);
                return stack;
            }
            return null;
        }

        public ItemStack func_70298_a(int i, int j) {
            return this.func_70301_a(i);
        }

        public ItemStack func_70304_b(int i) {
            return null;
        }

        public void func_70299_a(int i, ItemStack itemstack) {
        }

        public String func_145825_b() {
            return "quantumBackpackGenerator";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public int func_70297_j_() {
            return 1;
        }

        public void func_70296_d() {
        }

        public boolean func_70300_a(EntityPlayer entityplayer) {
            return false;
        }

        public void func_70295_k_() {
        }

        public void func_70305_f() {
        }

        public boolean func_94041_b(int i, ItemStack itemstack) {
            return false;
        }
    }

    public class BackpackSlot
    extends StackableContainer.ContainerSlot {
        public BackpackSlot(EntityPlayer player, IInventory inventory, int par2, int par3, int par4) {
            super(player, inventory, par2, par3, par4);
        }

        @Override
        public boolean canTakeStack(EntityPlayer player, boolean forRightClick) {
            String uuid = UniqueItem.getIdentifier(super.func_75211_c());
            if (uuid.equals("none") || forRightClick) {
                return true;
            }
            QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(player.field_70170_p, QuantumChestContainer.this.chestId);
            if (chest == null || !chest.canPlayerEdit(player) || chest.getUserCount(uuid, new HashSet<String>()) > 0) {
                QuantumChestContainer.this.container.theClientMayBeOutofSync = true;
                return false;
            }
            return !this.chainContains(uuid, true);
        }

        @Override
        public boolean func_75214_a(ItemStack stack) {
            QuantumChestTileEntity.VirtualQuantumChest chest = QuantumChestTileEntity.VirtualQuantumChest.getChest(this.player.field_70170_p, QuantumChestContainer.this.chestId);
            if (chest != null && !chest.canPlayerEdit(this.player)) {
                return false;
            }
            return stack == null || stack.func_77973_b() instanceof Backpack || stack.func_77973_b() instanceof QuantumBackpack;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (QuantumChestContainer.this.quantumSlot != null) {
                QuantumChestContainer.this.quantumSlot.func_75218_e();
            }
        }

        public void func_75220_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
            super.func_75220_a(par1ItemStack, par2ItemStack);
            if (QuantumChestContainer.this.quantumSlot != null) {
                QuantumChestContainer.this.quantumSlot.func_75218_e();
            }
        }
    }
}

