/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.backpacks.items.Backpack;
import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.PacketHandler;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.permissions.PacketHandler;
import brad16840.common.permissions.PermissionGroup;
import brad16840.common.permissions.PermissionPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.World;

public class BackpackCommand
extends CommandBase {
    private List<String> aliases = new ArrayList<String>();

    public BackpackCommand() {
        this.aliases.add("backpack");
    }

    public String func_71517_b() {
        return "backpack";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public int func_82362_a() {
        return 0;
    }

    public boolean func_71519_b(ICommandSender user) {
        return true;
    }

    public String func_71518_a(ICommandSender sender) {
        return "command.usage.backpack";
    }

    public static String getPlayerUuid(UniqueItemData data, String player) {
        String uuid = null;
        if (data.playerIds.containsKey(player)) {
            uuid = data.playerIds.get(player);
        }
        return uuid;
    }

    private EntityPlayer getPlayerFromSender(ICommandSender sender, String playerName) {
        if (sender instanceof EntityPlayer) {
            return (EntityPlayer)sender;
        }
        try {
            return BackpackCommand.func_82359_c((ICommandSender)sender, (String)playerName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void openPlayerPermissions(EntityPlayer player, World world) {
        if (world.field_72995_K) {
            return;
        }
        Common.channel.sendToPlayer(player, PacketHandler.SetPermissionPlayerData.create(player));
        player.openGui((Object)"backpacks16840", 7, world, 0, 0, 0);
    }

    public static boolean uuidIsBackpack(UniqueItemData data, String uuid) {
        if (uuid == null) {
            return false;
        }
        NBTTagCompound tag = data.getItemData(uuid, false);
        if (tag == null || !tag.func_74764_b("inventory") || !tag.func_74775_l("inventory").func_74764_b("container-type")) {
            return false;
        }
        String type = tag.func_74775_l("inventory").func_74779_i("container-type");
        return type.equals("backpack");
    }

    public static ItemStack getBoundBackpack(UniqueItemData data, String uuid) {
        if (uuid == null) {
            return null;
        }
        NBTTagCompound tag = data.getItemData(uuid, false);
        if (tag != null && tag.func_74764_b("inventory") && tag.func_74775_l("inventory").func_74764_b("container-type")) {
            String type = tag.func_74775_l("inventory").func_74779_i("container-type");
            if (!type.equals("backpack")) {
                return null;
            }
            UniqueItem.ContainerItem itemType = UniqueItem.getContainerType(type);
            ItemStack stack = new ItemStack((Item)itemType, 1);
            if (tag.func_74764_b("custom-name")) {
                stack.func_151001_c(tag.func_74779_i("custom-name"));
            }
            if (tag.func_74764_b("color")) {
                stack.func_77964_b(tag.func_74762_e("color"));
            }
            if ((tag = stack.func_77978_p()) == null) {
                tag = new NBTTagCompound();
                stack.func_77982_d(tag);
            }
            return stack;
        }
        return null;
    }

    public boolean handleSpecialCommands(UniqueItemData data, EntityPlayer player, String playerName, String[] args) throws CommandException {
        if (args.length < 1) {
            return false;
        }
        World world = player.field_70170_p;
        String first = args[0];
        if (first.equalsIgnoreCase("bind")) {
            if (args.length > 1) {
                throw new CommandException("command.info.bind", new Object[0]);
            }
            ItemStack stack = player.func_71045_bC();
            if (stack == null || !(stack.func_77973_b() instanceof Backpack)) {
                throw new CommandException("command.info.bind", new Object[0]);
            }
            String uuid = UniqueItem.getIdentifier(stack);
            if (uuid == null) {
                uuid = UUID.randomUUID().toString();
                while (data.items.containsKey(uuid)) {
                    uuid = UUID.randomUUID().toString();
                }
            }
            if (!data.items.containsKey(uuid) || data.getItemData(uuid, false) == null) {
                NBTTagCompound tag = stack.func_77978_p();
                if (tag == null) {
                    tag = new NBTTagCompound();
                    stack.func_77982_d(tag);
                }
                if (!tag.func_74764_b("color")) {
                    tag.func_74768_a("color", stack.func_77960_j());
                }
                UniqueItem.setIdentifier(player, stack, uuid);
                PermissionGroup group = PermissionGroup.getItemPermission(world, uuid);
                group.owner = PermissionGroup.getPlayerPermission(player);
                group.parent = PermissionGroup.getSpecialGroup(world, PermissionGroup.SpecialPermissionGroup.denyId);
                group.visibility = 2;
                group.markDirty(world);
            }
            if (!data.strictlyHasRequiredPermission(world, playerName, uuid, 2)) {
                throw new CommandException("problem.permission", new Object[]{"bind", "backpack"});
            }
            String existingUuid = BackpackCommand.getPlayerUuid(data, playerName);
            ItemStack existingStack = BackpackCommand.getBoundBackpack(data, existingUuid);
            int slot = player.field_71071_by.field_70461_c;
            if (existingStack != null) {
                UniqueItem.setIdentifier(player, existingStack, existingUuid);
            }
            player.field_71071_by.func_70299_a(slot, existingStack);
            player.field_71071_by.func_70296_d();
            data.setPlayerId(playerName, uuid);
            NBTTagCompound tag = data.getItemData(uuid, false);
            tag.func_74757_a("isEquipped", true);
            ArrayList<Object> ids = new ArrayList<Object>();
            ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
            data.subscribePlayer(player, uuid, tags, true);
            if (!tags.isEmpty() || !ids.isEmpty()) {
                Common.channel.sendToPlayer(player, new PacketHandler.InventoryIdResponse("none", ids, tags, -1, -1));
            }
            return true;
        }
        if (first.equalsIgnoreCase("unbind")) {
            if (args.length > 1) {
                throw new CommandException("command.info.bind", new Object[0]);
            }
            String existingUuid = BackpackCommand.getPlayerUuid(data, playerName);
            ItemStack existingStack = BackpackCommand.getBoundBackpack(data, existingUuid);
            if (existingStack == null) {
                throw new CommandException("command.problem.notbound", new Object[0]);
            }
            UniqueItem.setIdentifier(player, existingStack, existingUuid);
            int slot = player.field_71071_by.field_70461_c;
            if (player.func_71045_bC() == null) {
                player.field_71071_by.func_70299_a(slot, existingStack);
            } else {
                slot = player.field_71071_by.func_70447_i();
                if (slot >= 0) {
                    player.field_71071_by.func_70299_a(slot, existingStack);
                } else {
                    player.func_146097_a(existingStack, true, false);
                }
            }
            player.field_71071_by.func_70296_d();
            data.setPlayerId(playerName, null);
            return true;
        }
        if (first.equalsIgnoreCase("equip") || first.equalsIgnoreCase("unequip")) {
            if (args.length > 1) {
                throw new CommandException("command.info.equip", new Object[0]);
            }
            String targetUuid = BackpackCommand.getPlayerUuid(data, playerName);
            if (!BackpackCommand.uuidIsBackpack(data, targetUuid)) {
                throw new CommandException("command.problem.notbound", new Object[0]);
            }
            if (!data.strictlyHasRequiredPermission(world, playerName, targetUuid, 2)) {
                throw new CommandException("problem.permission", new Object[]{"open", "backpack"});
            }
            BackpackCommand.equipBackpack(data, player, targetUuid, args[0].equalsIgnoreCase("equip"));
            return true;
        }
        return false;
    }

    public void func_71515_b(ICommandSender sender, String[] args) throws CommandException {
        PermissionGroup moderators;
        String playerName = sender.func_70005_c_();
        EntityPlayer player = this.getPlayerFromSender(sender, playerName);
        if (player == null) {
            return;
        }
        World world = sender.func_130014_f_();
        if (args.length > 0 && (args[0].equalsIgnoreCase("permission") || args[0].equalsIgnoreCase("permissions"))) {
            this.openPlayerPermissions(player, world);
            return;
        }
        UniqueItemData data = UniqueItemData.get(world);
        if (!Common.allowBackpackCommand) {
            moderators = PermissionGroup.getSpecialGroup(world, PermissionGroup.ModeratorPermissionGroup.id);
            if (args.length < 2 || !args[0].equalsIgnoreCase("open") || !moderators.canUse(PermissionGroup.getPlayerPermission(player))) {
                BackpackCommand.openBackpack(data, player, null);
                throw new CommandException("command.problem.isdisabled", new Object[0]);
            }
        }
        if (args.length > 1 && (args[1].equalsIgnoreCase("help") || args[1].equalsIgnoreCase("usage"))) {
            if (!Common.allowBackpackCommand) {
                throw new CommandException("command.problem.isdisabled", new Object[0]);
            }
            throw new CommandException("command.usage.backpack", new Object[0]);
        }
        if (this.handleSpecialCommands(data, player, playerName, args)) {
            return;
        }
        if (args.length > 0 && !args[0].equalsIgnoreCase("open")) {
            throw new CommandException("command.usage.backpack", new Object[0]);
        }
        if (args.length > 1 && !(moderators = PermissionGroup.getSpecialGroup(world, PermissionGroup.ModeratorPermissionGroup.id)).canUse(PermissionGroup.getPlayerPermission(player))) {
            if (!Common.allowBackpackCommand) {
                throw new CommandException("command.problem.isdisabled", new Object[0]);
            }
            throw new CommandException("problem.permission", new Object[]{"execute", "command"});
        }
        String targetUuid = BackpackCommand.getPlayerUuid(data, playerName);
        if (args.length > 1) {
            targetUuid = args[1];
            if (!UniqueItem.isUUID("BCMod: " + targetUuid)) {
                targetUuid = args.length > 2 ? args[2] : BackpackCommand.getPlayerUuid(data, targetUuid);
            }
        }
        if (targetUuid == null || !UniqueItem.isUUID("BCMod: " + targetUuid)) {
            if (args.length < 2) {
                if (!Common.allowBackpackCommand) {
                    throw new CommandException("command.problem.isdisabled", new Object[0]);
                }
                throw new CommandException("command.problem.notbound", new Object[0]);
            }
            if (targetUuid == null) {
                if (!Common.allowBackpackCommand) {
                    throw new CommandException("command.problem.isdisabled", new Object[0]);
                }
                throw new CommandException("command.problem.otherplayernotbound", new Object[0]);
            }
            throw new CommandException("command.problem.backpacknotfound", new Object[0]);
        }
        if (!data.items.containsKey(targetUuid) || data.getItemData(targetUuid, false) == null) {
            throw new CommandException("command.problem.backpacknotfound", new Object[0]);
        }
        if (!data.strictlyHasRequiredPermission(world, playerName, targetUuid, 2)) {
            throw new CommandException("problem.permission", new Object[]{"open", "backpack"});
        }
        BackpackCommand.openBackpack(data, player, targetUuid);
    }

    public static void equipBackpack(UniqueItemData data, EntityPlayer player, String uuid, boolean shouldEquip) {
        NBTTagCompound tag = data.getItemData(uuid, false);
        if (tag == null) {
            return;
        }
        tag.func_74757_a("isEquipped", shouldEquip);
        ArrayList<Object> ids = new ArrayList<Object>();
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        data.subscribePlayer(player, uuid, tags, true);
        if (!tags.isEmpty() || !ids.isEmpty()) {
            Common.channel.sendToPlayer(player, new PacketHandler.InventoryIdResponse("none", ids, tags, -1, -1));
        }
    }

    public static void openBackpack(UniqueItemData data, EntityPlayer player, String uuid) {
        PermissionGroup moderators;
        ArrayList<Object> ids = new ArrayList<Object>();
        ArrayList<NBTTagCompound> tags = new ArrayList<NBTTagCompound>();
        if (uuid != null) {
            data.subscribePlayer(player, uuid, tags, true);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            String id;
            ItemStack s = player.field_71071_by.func_70301_a(i);
            if (s == null || !(s.func_77973_b() instanceof UniqueItem)) continue;
            if (!UniqueItem.hasIdentifier(s) && (id = Common.requestInventoryIdentifier(player, (IInventory)player.field_71071_by, i)) != null) {
                ids.add(i);
                ids.add(id);
            }
            if (((UniqueItem)s.func_77973_b()).hasUniqueData()) {
                data.subscribePlayer(player, Common.requestInventoryIdentifier(player, (IInventory)player.field_71071_by, i), tags, true);
                continue;
            }
            if (!(s.func_77973_b() instanceof QuantumBackpack)) continue;
            data.subscribePlayer(player, QuantumBackpack.getInfo(s), tags, true);
        }
        if (!tags.isEmpty() || !ids.isEmpty()) {
            Common.channel.sendToPlayer(player, new PacketHandler.InventoryIdResponse("none", ids, tags, -1, -1));
        }
        if (uuid == null) {
            return;
        }
        if (!Common.allowBackpackCommand && !(moderators = PermissionGroup.getSpecialGroup(player.field_70170_p, PermissionGroup.ModeratorPermissionGroup.id)).canUse(PermissionGroup.getPlayerPermission(player))) {
            return;
        }
        ItemStack backpack = new ItemStack((Item)Common.backpack, 1);
        NBTTagCompound tag = backpack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
            backpack.func_77982_d(tag);
        }
        tag.func_74778_a("stackId", uuid);
        NBTTagList nlore = new NBTTagList();
        NBTTagList lore = tag.func_150295_c("Lore", 8);
        for (int i = 0; i < lore.func_74745_c(); ++i) {
            String entry = lore.func_150307_f(i);
            if (UniqueItem.isUUID(entry)) continue;
            nlore.func_74742_a((NBTBase)new NBTTagString(entry));
        }
        nlore.func_74742_a((NBTBase)new NBTTagString("BCMod: " + uuid));
        tag.func_74782_a("Lore", (NBTBase)nlore);
        Common.proxy.guiItem = backpack;
        ((UniqueItem.OpenableItem)backpack.func_77973_b()).open(player, backpack, player.field_70170_p);
    }

    public List<String> func_71516_a(ICommandSender sender, String[] args) {
        PermissionGroup moderators;
        MinecraftServer server = MinecraftServer.func_71276_C();
        World world = sender.func_130014_f_();
        String playerName = sender.func_70005_c_();
        if (!Common.allowBackpackCommand) {
            moderators = PermissionGroup.getSpecialGroup(world, PermissionGroup.ModeratorPermissionGroup.id);
            if (args.length < 1 || !args[0].equalsIgnoreCase("open") || !moderators.canUse(PermissionGroup.getPlayerPermission(world, playerName))) {
                if (args.length == 1) {
                    return BackpackCommand.func_71530_a((String[])args, (String[])new String[]{"permissions"});
                }
                return Collections.emptyList();
            }
        }
        if (args.length == 1) {
            UniqueItemData data = UniqueItemData.get(world);
            if (BackpackCommand.getPlayerUuid(data, playerName) != null) {
                return BackpackCommand.func_71530_a((String[])args, (String[])new String[]{"permissions", "equip", "unequip", "bind", "unbind", "open"});
            }
            return BackpackCommand.func_71530_a((String[])args, (String[])new String[]{"permissions", "bind"});
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("open")) {
                moderators = PermissionGroup.getSpecialGroup(world, PermissionGroup.ModeratorPermissionGroup.id);
                if (moderators.canUse(PermissionGroup.getPlayerPermission(world, playerName))) {
                    ArrayList<String> candidates = new ArrayList<String>();
                    Collections.addAll(candidates, server.func_71213_z());
                    if (world != null) {
                        UniqueItemData data = UniqueItemData.get(world);
                        for (String key : data.playerIds.keySet()) {
                            if (candidates.contains(key)) continue;
                            candidates.add(key);
                        }
                        for (String uuid : data.items.keySet()) {
                            if (!BackpackCommand.uuidIsBackpack(data, uuid)) continue;
                            candidates.add(uuid);
                        }
                    }
                    candidates = new ArrayList(BackpackCommand.func_71530_a((String[])args, (String[])candidates.toArray(new String[candidates.size()])));
                    return candidates;
                }
            } else if (args[0].equalsIgnoreCase("equip") || args[0].equalsIgnoreCase("unequip") || args[0].equalsIgnoreCase("bind") || args[0].equalsIgnoreCase("unbind")) {
                return BackpackCommand.func_71530_a((String[])args, (String[])new String[]{"usage"});
            }
        } else if (args.length == 3 && args[0].equalsIgnoreCase("open") && (moderators = PermissionGroup.getSpecialGroup(world, PermissionGroup.ModeratorPermissionGroup.id)).canUse(PermissionGroup.getPlayerPermission(world, playerName))) {
            String player = args[1];
            UniqueItemData data = UniqueItemData.get(world);
            PermissionPlayer targetPlayer = PermissionGroup.getPlayerPermission(world, player);
            ArrayList<String> candidates = new ArrayList<String>();
            for (String uuid : data.items.keySet()) {
                if (!PermissionGroup.getItemPermission(world, uuid).isOwner(targetPlayer) || !BackpackCommand.uuidIsBackpack(data, uuid)) continue;
                candidates.add(uuid);
            }
            return BackpackCommand.func_71530_a((String[])args, (String[])candidates.toArray(new String[candidates.size()]));
        }
        return Collections.emptyList();
    }

    public boolean func_82358_a(String[] args, int index) {
        return false;
    }
}

