/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.common.CustomPacket;
import brad16840.common.Logger;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.handshake.NetworkDispatcher;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;

@ChannelHandler.Sharable
public class MessageChannel
extends FMLIndexedMessageToMessageCodec<Message> {
    private EnumMap<Side, FMLEmbeddedChannel> channels;
    private byte discriminator = 0;

    public MessageChannel registerMessage(Class<? extends Message> clazz) {
        this.addDiscriminator(this.discriminator, clazz);
        this.discriminator = (byte)(this.discriminator + 1);
        FMLEmbeddedChannel channel = this.channels.get(Side.CLIENT);
        String type = channel.findChannelHandlerNameForType(MessageChannel.class);
        channel.pipeline().addAfter(type, clazz.getName(), (ChannelHandler)new SimplestChannelHandlerWrapper());
        channel = this.channels.get(Side.SERVER);
        type = channel.findChannelHandlerNameForType(MessageChannel.class);
        channel.pipeline().addAfter(type, clazz.getName(), (ChannelHandler)new SimplestChannelHandlerWrapper());
        return this;
    }

    public void encodeInto(ChannelHandlerContext ctx, Message message, ByteBuf target) throws Exception {
        CustomPacket packet = new CustomPacket(target);
        message.send(packet);
    }

    public void decodeInto(ChannelHandlerContext ctx, ByteBuf source, Message message) {
        CustomPacket.CustomPacketReader reader = new CustomPacket.CustomPacketReader(source);
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (side == Side.SERVER) {
            EntityPlayerMP player = ((NetHandlerPlayServer)ctx.channel().attr((AttributeKey)NetworkRegistry.NET_HANDLER).get()).field_147369_b;
            message.receive((EntityPlayer)player, reader, true);
        } else if (side == Side.CLIENT) {
            message.receive(this.getClientPlayer(), reader, false);
        }
    }

    public static Side getEffectiveSide() {
        Thread thr = Thread.currentThread();
        if (thr.getName().equals("Server thread")) {
            return Side.SERVER;
        }
        if (thr.getName().startsWith("Netty") && thr.getName().contains("Server")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    @SideOnly(value=Side.CLIENT)
    private EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void initialize(String channel) {
        this.channels = NetworkRegistry.INSTANCE.newChannel(channel, new ChannelHandler[]{this});
    }

    public void sendToAll(Message message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void sendToPlayer(EntityPlayer player, Message message) {
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.channels.get(Side.SERVER).attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        NetworkDispatcher dispatcher = (NetworkDispatcher)((EntityPlayerMP)player).field_71135_a.field_147371_a.channel().attr(NetworkDispatcher.FML_DISPATCHER).get();
        if (dispatcher != null) {
            this.channels.get(Side.SERVER).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
        }
    }

    public void sendToServer(Message message) {
        this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.channels.get(Side.CLIENT).writeAndFlush((Object)message).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public static class SimplestChannelHandlerWrapper
    extends SimpleChannelInboundHandler<Message> {
        protected void channelRead0(ChannelHandlerContext ctx, Message msg) throws Exception {
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            Logger.logger.error("SimplestChannelHandlerWrapper exception", cause);
            super.exceptionCaught(ctx, cause);
        }
    }

    public static abstract class Message {
        protected Object[] args;
        protected Class[] classes = null;

        public Message() {
            this.args = new Object[0];
        }

        public Message(Object ... args) {
            this.args = args;
        }

        public void setClasses(Class ... classes) {
            this.classes = classes;
        }

        public void send(CustomPacket packet) {
            packet.writeAll(this.args, this.classes);
        }

        public abstract void receive(EntityPlayer var1, CustomPacket.CustomPacketReader var2, boolean var3);
    }
}

