/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common;

import brad16840.backpacks.items.QuantumBackpack;
import brad16840.common.Common;
import brad16840.common.Logger;
import brad16840.common.PacketHandler;
import brad16840.common.Translatable;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemInventory;
import brad16840.common.permissions.PermissionGroup;
import brad16840.common.permissions.PermissionPlayer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class UniqueItemData
extends WorldSavedData {
    private static final String identifier = "BCMod-Items";
    private boolean isClient;
    public HashMap<String, NBTTagCompound> items = new HashMap();
    public HashMap<String, String> playerIds = new HashMap();
    public HashMap<String, NBTTagCompound> blocks = new HashMap();
    public HashMap<String, WeakHashMap<EntityPlayer, Integer>> subscribedPlayers = new HashMap();
    public static Translatable genericItem = new Translatable("genericitem", new Object[0]);
    public static UniqueItemData uniqueItemDataServer;
    public static UniqueItemData uniqueItemDataClient;
    private static HashMap<EntityPlayer, UniqueItemData> clientDataCache;

    public static void loadData() {
        try {
            Exception exception;
            boolean loaded;
            block13: {
                NBTTagCompound nbttagcompound;
                FileInputStream fileinputstream;
                File dataFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "data");
                if (!dataFolder.exists()) {
                    dataFolder.mkdir();
                }
                uniqueItemDataServer = new UniqueItemData(identifier);
                loaded = false;
                exception = null;
                File file1 = new File(dataFolder, "BCMod-Items.dat_new");
                if (file1.exists()) {
                    UniqueItemData.rollDataFiles(dataFolder);
                }
                file1 = new File(dataFolder, "BCMod-Items.dat");
                try {
                    if (file1.exists()) {
                        fileinputstream = new FileInputStream(file1);
                        nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                        uniqueItemDataServer.func_76184_a(nbttagcompound.func_74775_l("data"));
                        loaded = true;
                    }
                }
                catch (Exception ex) {
                    loaded = false;
                    exception = ex;
                }
                if (!loaded) {
                    file1 = new File(dataFolder, "BCMod-Items.dat_old");
                    try {
                        if (file1.exists()) {
                            fileinputstream = new FileInputStream(file1);
                            nbttagcompound = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                            fileinputstream.close();
                            uniqueItemDataServer.func_76184_a(nbttagcompound.func_74775_l("data"));
                            if (exception != null) {
                                exception.printStackTrace();
                                Logger.logger.error("Couldn't load BCMod-Items.dat but managed to load BCMod-Items.dat_old", (Throwable)exception);
                            }
                            loaded = true;
                        }
                    }
                    catch (Exception ex) {
                        loaded = false;
                        if (exception != null) break block13;
                        exception = ex;
                    }
                }
            }
            if (!loaded && exception != null) {
                throw exception;
            }
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
            throw new RuntimeException("Couldn't load BCMod-Items.dat", exception1);
        }
    }

    private static void rollDataFiles(File dataFolder) {
        File newFile = new File(dataFolder, "BCMod-Items.dat_new");
        if (!newFile.exists()) {
            throw new RuntimeException("data\\BCMod-Items.dat_new couldn't be saved");
        }
        File oldFile = new File(dataFolder, "BCMod-Items.dat_old");
        File file = new File(dataFolder, "BCMod-Items.dat");
        if (oldFile.exists() && !oldFile.delete()) {
            throw new RuntimeException("data\\BCMod-Items.dat_old couldn't be deleted");
        }
        if (file.exists()) {
            if (!file.renameTo(oldFile)) {
                throw new RuntimeException("data\\BCMod-Items.dat couldn't be renamed to data\\BCMod-Items.dat_old");
            }
            if (file.exists() && !file.delete()) {
                throw new RuntimeException("data\\BCMod-Items.dat couldn't be deleted");
            }
        }
        if (!newFile.renameTo(file)) {
            throw new RuntimeException("data\\BCMod-Items.dat_new couldn't be renamed to data\\BCMod-Items.dat");
        }
        if (newFile.exists() && !newFile.delete()) {
            throw new RuntimeException("data\\BCMod-Items.dat_new couldn't be deleted");
        }
    }

    public static void saveData(boolean onlyIfDirty) {
        try {
            File file;
            File newFile;
            if (onlyIfDirty && !uniqueItemDataServer.func_76188_b()) {
                return;
            }
            File dataFolder = new File(DimensionManager.getCurrentSaveRootDirectory(), "data");
            if (!dataFolder.exists()) {
                dataFolder.mkdir();
            }
            if ((newFile = new File(dataFolder, "BCMod-Items.dat_new")).exists() && !(file = new File(dataFolder, "BCMod-Items.dat")).exists()) {
                newFile.renameTo(file);
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            uniqueItemDataServer.func_76187_b(nbttagcompound);
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74782_a("data", (NBTBase)nbttagcompound);
            FileOutputStream fileoutputstream = new FileOutputStream(newFile);
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound1, (OutputStream)fileoutputstream);
            fileoutputstream.close();
            UniqueItemData.rollDataFiles(dataFolder);
            uniqueItemDataServer.func_76186_a(false);
        }
        catch (Exception exception1) {
            exception1.printStackTrace();
            Logger.logger.error("Couldn't save BCMod-Items.dat", (Throwable)exception1);
            new Translatable("message.couldnotsave", new Object[0]).broadcast();
        }
    }

    public UniqueItemData(String par1Str) {
        super(par1Str);
    }

    public void func_76184_a(NBTTagCompound tag) {
        Object[] keys;
        this.subscribedPlayers.clear();
        this.items.clear();
        this.blocks.clear();
        this.playerIds.clear();
        for (Object key : keys = tag.func_150296_c().toArray()) {
            NBTTagCompound element = tag.func_74775_l((String)key);
            if (element.func_74764_b("playerId")) {
                this.playerIds.put(element.func_74779_i("playerName"), element.func_74779_i("playerId"));
                continue;
            }
            if (element.func_74764_b("uuid")) {
                this.items.put(element.func_74779_i("uuid"), element);
                continue;
            }
            if (!element.func_74764_b("blockpos")) continue;
            this.blocks.put(element.func_74779_i("blockpos"), element);
        }
    }

    public void func_76187_b(NBTTagCompound tag) {
        for (Map.Entry<String, String> entry : this.playerIds.entrySet()) {
            NBTTagCompound subTag = new NBTTagCompound();
            subTag.func_74778_a("playerName", entry.getKey());
            subTag.func_74778_a("playerId", entry.getValue());
            tag.func_74782_a("P_" + entry.getKey(), (NBTBase)subTag);
        }
        for (Map.Entry<String, String> entry : this.items.entrySet()) {
            tag.func_74782_a(entry.getKey(), (NBTBase)entry.getValue());
        }
        for (Map.Entry<String, String> entry : this.blocks.entrySet()) {
            tag.func_74782_a(entry.getKey(), (NBTBase)entry.getValue());
        }
    }

    public void setPlayerId(String playerName, String playerId) {
        if (playerId == null) {
            this.playerIds.remove(playerName);
            this.func_76185_a();
            return;
        }
        this.playerIds.put(playerName, playerId);
        this.func_76185_a();
    }

    public void setItemData(String uuid, NBTTagCompound tag) {
        this.items.put(uuid, tag);
        this.markItemDirty(uuid);
    }

    public void setBlockData(String blockpos, NBTTagCompound tag) {
        this.blocks.put(blockpos, tag);
        this.markBlockDirty(blockpos);
    }

    public void markItemDirty(String uuid) {
        super.func_76185_a();
        if (this.isClient) {
            return;
        }
        if (this.subscribedPlayers.containsKey(uuid)) {
            for (EntityPlayer player : this.subscribedPlayers.get(uuid).keySet()) {
                if (player == null) continue;
                int accessLevel = PermissionGroup.getGroup(player.field_70170_p, "I_" + uuid).getAccessLevel(PermissionGroup.getPlayerPermission(player));
                this.subscribedPlayers.get(uuid).put(player, accessLevel);
                NBTTagCompound tag = null;
                if (accessLevel > 0) {
                    tag = this.getItemData(uuid, false);
                }
                if (tag != null) {
                    tag.func_74768_a("accessLevel", accessLevel);
                }
                if (!this.items.containsKey(uuid) || this.items.get(uuid) == null || this.items.get(uuid).func_74764_b("deleted")) {
                    tag = new NBTTagCompound();
                    tag.func_74778_a("uuid", uuid);
                    tag.func_74757_a("deleted", true);
                    this.subscribedPlayers.get(uuid).put(player, 0);
                }
                Common.channel.sendToPlayer(player, new PacketHandler.DataUpdate(tag));
            }
        }
    }

    public void markBlockDirty(String blockpos) {
        super.func_76185_a();
        if (this.isClient) {
            return;
        }
        if (this.subscribedPlayers.containsKey(blockpos)) {
            for (EntityPlayer player : this.subscribedPlayers.get(blockpos).keySet()) {
                if (player == null) continue;
                int accessLevel = PermissionGroup.getGroup(player.field_70170_p, "I_" + blockpos).getAccessLevel(PermissionGroup.getPlayerPermission(player));
                this.subscribedPlayers.get(blockpos).put(player, accessLevel);
                NBTTagCompound tag = null;
                if (accessLevel > 0) {
                    tag = this.getBlockData(blockpos, false);
                }
                if (tag != null) {
                    tag.func_74768_a("accessLevel", accessLevel);
                }
                if (!this.blocks.containsKey(blockpos) || this.blocks.get(blockpos) == null || this.blocks.get(blockpos).func_74764_b("deleted")) {
                    tag = new NBTTagCompound();
                    tag.func_74778_a("uuid", blockpos);
                    tag.func_74757_a("deleted", true);
                    this.subscribedPlayers.get(blockpos).put(player, 0);
                }
                Common.channel.sendToPlayer(player, new PacketHandler.DataUpdate(tag));
            }
        }
    }

    public void deleteItem(World world, String uuid) {
        if (this.isClient) {
            return;
        }
        (uuid.startsWith("@") ? this.blocks : this.items).remove(uuid);
        PermissionGroup.getGroup(world, "I_" + uuid).deleteGroup(world);
        if (this.subscribedPlayers.containsKey(uuid)) {
            for (EntityPlayer player : this.subscribedPlayers.get(uuid).keySet()) {
                if (player != null) {
                    NBTTagCompound tag = new NBTTagCompound();
                    tag.func_74778_a("uuid", uuid);
                    tag.func_74757_a("deleted", true);
                    Common.channel.sendToPlayer(player, new PacketHandler.DataUpdate(tag));
                }
                this.subscribedPlayers.get(uuid).put(player, 0);
            }
        }
        this.func_76185_a();
    }

    public boolean isPermissionDeleted(EntityPlayer player, String uuid) {
        HashMap<String, NBTTagCompound> map;
        if (uuid.equals("none")) {
            return true;
        }
        HashMap<String, NBTTagCompound> hashMap = map = uuid.startsWith("@") ? this.blocks : this.items;
        return !this.isClient ? this.subscribedPlayers.containsKey(uuid) && this.subscribedPlayers.get(uuid).containsKey(player) && !map.containsKey(uuid) : map.containsKey(uuid) && map.get(uuid) != null && map.get(uuid).func_74764_b("deleted");
    }

    public boolean hasRequiredPermission(EntityPlayer player, String uuid, int accessLevel) {
        HashMap<String, NBTTagCompound> map;
        if (uuid.equals("none")) {
            return false;
        }
        HashMap<String, NBTTagCompound> hashMap = map = uuid.startsWith("@") ? this.blocks : this.items;
        return !this.isClient ? this.subscribedPlayers.containsKey(uuid) && this.subscribedPlayers.get(uuid).containsKey(player) && map.containsKey(uuid) && this.subscribedPlayers.get(uuid).get(player) >= accessLevel : map.containsKey(uuid) && map.get(uuid) != null && !map.get(uuid).func_74764_b("deleted") && map.get(uuid).func_74762_e("accessLevel") >= accessLevel;
    }

    public boolean strictlyHasRequiredPermission(World world, String player, String uuid, int accessLevel) {
        if (this.isClient) {
            return false;
        }
        return PermissionGroup.getGroup(world, "I_" + uuid).getAccessLevel((PermissionPlayer)PermissionGroup.getGroup(world, "P_" + player)) >= accessLevel;
    }

    public NBTTagCompound getItemData(EntityPlayer player, String uuid) {
        if (uuid.equals("none")) {
            return null;
        }
        if (!this.isClient ? this.subscribedPlayers.containsKey(uuid) && this.subscribedPlayers.get(uuid).containsKey(player) && this.items.containsKey(uuid) && this.subscribedPlayers.get(uuid).get(player) > 0 : this.items.containsKey(uuid) && this.items.get(uuid) != null && !this.items.get(uuid).func_74764_b("deleted")) {
            return this.items.get(uuid);
        }
        return null;
    }

    public NBTTagCompound getBlockData(EntityPlayer player, String blockpos) {
        if (!this.isClient ? this.subscribedPlayers.containsKey(blockpos) && this.subscribedPlayers.get(blockpos).containsKey(player) && this.blocks.containsKey(blockpos) && this.subscribedPlayers.get(blockpos).get(player) > 0 : this.blocks.containsKey(blockpos) && this.blocks.get(blockpos) != null && !this.blocks.get(blockpos).func_74764_b("deleted")) {
            return this.blocks.get(blockpos);
        }
        return null;
    }

    public NBTTagCompound getItemData(String uuid, boolean shouldCreate) {
        if (uuid.equals("none")) {
            return null;
        }
        if (this.items.containsKey(uuid) && this.items.get(uuid) != null && !this.items.get(uuid).func_74764_b("deleted")) {
            return this.items.get(uuid);
        }
        if (!shouldCreate) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("uuid", uuid);
        this.items.put(uuid, tag);
        this.markItemDirty(uuid);
        return tag;
    }

    public NBTTagCompound getBlockData(String blockpos, boolean shouldCreate) {
        if (blockpos.equals("none")) {
            return null;
        }
        if (this.blocks.containsKey(blockpos) && this.blocks.get(blockpos) != null && !this.blocks.get(blockpos).func_74764_b("deleted")) {
            return this.blocks.get(blockpos);
        }
        if (!shouldCreate) {
            return null;
        }
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("blockpos", blockpos);
        this.blocks.put(blockpos, tag);
        this.markBlockDirty(blockpos);
        return tag;
    }

    @SideOnly(value=Side.CLIENT)
    private static UniqueItemData getClientData() {
        if (clientDataCache.containsKey(Minecraft.func_71410_x().field_71439_g)) {
            return clientDataCache.get(Minecraft.func_71410_x().field_71439_g);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static void saveClientData(UniqueItemData data) {
        clientDataCache.put((EntityPlayer)Minecraft.func_71410_x().field_71439_g, data);
    }

    public static UniqueItemData get(World world) {
        UniqueItemData data;
        boolean clientside;
        boolean bl = clientside = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        if (clientside && (data = UniqueItemData.getClientData()) != null) {
            return data;
        }
        UniqueItemData uniqueItemData = data = clientside ? uniqueItemDataClient : uniqueItemDataServer;
        if (data == null) {
            data = new UniqueItemData(identifier);
            if (clientside) {
                uniqueItemDataClient = data;
            } else {
                uniqueItemDataServer = data;
            }
        }
        data.isClient = world.field_72995_K;
        if (clientside) {
            UniqueItemData.saveClientData(data);
        }
        return data;
    }

    public boolean isSubscribed(String uuid) {
        if (this.isClient) {
            return this.subscribedPlayers.containsKey(uuid);
        }
        return true;
    }

    public void subscribePlayer(EntityPlayer player, String uuid, ArrayList<NBTTagCompound> tags, boolean forceSubscribed) {
        if (uuid == null) {
            return;
        }
        if (uuid.startsWith("@")) {
            this.subscribePlayerToBlock(player, uuid, tags);
            return;
        }
        if (uuid.equals("none")) {
            return;
        }
        if (!this.items.containsKey(uuid) || this.items.get(uuid) == null || this.items.get(uuid).func_74764_b("deleted")) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("uuid", uuid);
            tag.func_74757_a("deleted", true);
            tags.add(tag);
            if (!this.subscribedPlayers.containsKey(uuid)) {
                this.subscribedPlayers.put(uuid, new WeakHashMap());
            }
            this.subscribedPlayers.get(uuid).put(player, 0);
            return;
        }
        int accessLevel = PermissionGroup.getGroup(player.field_70170_p, "I_" + uuid).getAccessLevel(PermissionGroup.getPlayerPermission(player));
        if (this.subscribedPlayers.containsKey(uuid) && this.subscribedPlayers.get(uuid).containsKey(player) && this.subscribedPlayers.get(uuid).get(player) == accessLevel) {
            return;
        }
        if (!this.subscribedPlayers.containsKey(uuid)) {
            this.subscribedPlayers.put(uuid, new WeakHashMap());
        }
        this.subscribedPlayers.get(uuid).put(player, accessLevel);
        if (accessLevel < 1) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("uuid", uuid);
            tag.func_74757_a("denied", true);
            tags.add(tag);
            return;
        }
        NBTTagCompound tag = this.items.get(uuid);
        tag.func_74768_a("accessLevel", accessLevel);
        tags.add(tag);
        if (tag.func_74764_b("inventory") && tag.func_74775_l("inventory").func_74764_b("container-type")) {
            if (!forceSubscribed && UniqueItem.getContainerType(tag.func_74775_l("inventory").func_74779_i("container-type")).subscribeToContents()) {
                forceSubscribed = true;
            }
            if (forceSubscribed) {
                UniqueItemInventory inventory = UniqueItemInventory.getInventory(player, uuid);
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack stack = inventory.func_70301_a(i);
                    if (stack != null && stack.func_77973_b() instanceof QuantumBackpack) {
                        this.subscribePlayer(player, QuantumBackpack.getInfo(stack), tags, forceSubscribed);
                        continue;
                    }
                    if (!UniqueItem.hasIdentifier(stack) || !((UniqueItem)stack.func_77973_b()).hasUniqueData()) continue;
                    this.subscribePlayer(player, UniqueItem.getIdentifier(stack), tags, forceSubscribed);
                }
            }
        }
    }

    private void subscribePlayerToBlock(EntityPlayer player, String blockpos, ArrayList<NBTTagCompound> tags) {
        UniqueItem.ProtectedBlock type;
        if (blockpos == null) {
            return;
        }
        if (!this.blocks.containsKey(blockpos) || this.blocks.get(blockpos) == null || this.blocks.get(blockpos).func_74764_b("deleted")) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("uuid", blockpos);
            tag.func_74757_a("deleted", true);
            tags.add(tag);
            if (!this.subscribedPlayers.containsKey(blockpos)) {
                this.subscribedPlayers.put(blockpos, new WeakHashMap());
            }
            this.subscribedPlayers.get(blockpos).put(player, 0);
            return;
        }
        int accessLevel = PermissionGroup.getGroup(player.field_70170_p, "I_" + blockpos).getAccessLevel(PermissionGroup.getPlayerPermission(player));
        if (this.subscribedPlayers.containsKey(blockpos) && this.subscribedPlayers.get(blockpos).containsKey(player) && this.subscribedPlayers.get(blockpos).get(player) == accessLevel) {
            return;
        }
        if (!this.subscribedPlayers.containsKey(blockpos)) {
            this.subscribedPlayers.put(blockpos, new WeakHashMap());
        }
        this.subscribedPlayers.get(blockpos).put(player, accessLevel);
        if (accessLevel < 1) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("uuid", blockpos);
            tag.func_74757_a("denied", true);
            tags.add(tag);
            return;
        }
        NBTTagCompound tag = this.blocks.get(blockpos);
        tag.func_74768_a("accessLevel", accessLevel);
        tags.add(tag);
        if (tag.func_74764_b("block-type") && (type = UniqueItem.getProtectedBlockType(tag.func_74779_i("block-type"))) != null) {
            type.subscribeToSubItems(player, this, tag, tags);
        }
    }

    public void updateData(NBTTagCompound tag) {
        if (tag == null) {
            return;
        }
        if (tag.func_74767_n("denied")) {
            String name = tag.func_74779_i("uuid");
            this.subscribedPlayers.put(name, null);
            (name.startsWith("@") ? this.blocks : this.items).put(name, null);
            return;
        }
        if (tag.func_74764_b("deleted")) {
            String name = tag.func_74779_i("uuid");
            this.subscribedPlayers.put(name, null);
            (name.startsWith("@") ? this.blocks : this.items).put(name, tag);
            return;
        }
        String uuid = null;
        if (tag.func_74764_b("blockpos")) {
            uuid = tag.func_74779_i("blockpos");
        } else if (tag.func_74764_b("uuid")) {
            uuid = tag.func_74779_i("uuid");
        } else {
            return;
        }
        this.subscribedPlayers.put(uuid, null);
        (uuid.startsWith("@") ? this.blocks : this.items).put(uuid, tag);
    }

    public static Translatable permissionError(String action, Object item) {
        return new Translatable("problem.permission", new Translatable("action.permission." + action, new Object[0]), item);
    }

    static {
        clientDataCache = new HashMap();
    }
}

