/*
 * Decompiled with CFR 0.152.
 */
package brad16840.common.gui;

import brad16840.common.ContainerStack;
import brad16840.common.StackableContainer;
import brad16840.common.UniqueItem;
import brad16840.common.UniqueItemData;
import brad16840.common.UniqueItemInventory;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class CraftingContainer
extends StackableContainer {
    private static final ResourceLocation texture = new ResourceLocation("backpacks16840", "textures/gui/crafting.png");
    public CraftingContainerCallbackContainer callbackContainer = new CraftingContainerCallbackContainer();
    public InventoryCrafting craftMatrix = null;
    public IInventory craftResult = new InventoryCraftResult();
    public World world;
    public CraftingContainerSlot craftingSlot;

    public CraftingContainer(EntityPlayer player) {
        super(130, 100);
        this.world = player.field_70170_p;
    }

    protected CraftingContainer(EntityPlayer player, int width, int height) {
        super(width, height);
        this.world = player.field_70170_p;
    }

    @Override
    public boolean initContainer(EntityPlayer player) {
        if (this.craftMatrix == null) {
            this.craftMatrix = new CraftingContainerInventory(this.container, 3, 3);
        }
        this.craftingSlot = new CraftingContainerSlot(player, (IInventory)this.craftMatrix, this.craftResult, 0, 102, 36 + this.getOffset());
        this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_OUT, this.craftingSlot);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 3; ++x) {
                this.addSlotToContainer(ContainerStack.ContainerSection.CRAFTING_IN, new StackableContainer.ContainerSlot(this, player, (IInventory)this.craftMatrix, x + y * 3, 8 + x * 18, this.getOffset() + 18 + y * 18));
            }
        }
        this.callbackContainer.func_75130_a((IInventory)this.craftMatrix);
        return true;
    }

    @Override
    public boolean static_refreshInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initButtons() {
        final int stackIdCache = this.stackId;
        this.gui.addButton(new StackableContainer.ContainerButton(this, 0, 0, this.container.layout.isTop(this.stackId) ? 0 : this.guiHeight - 20, this.guiWidth, 20, this.gui.getBackButtonText(this), new ContainerStack.Callback(){

            @Override
            public void call() {
                CraftingContainer.this.gui.closeContainer(stackIdCache);
            }
        }, 68));
    }

    @Override
    public void onClosed(EntityPlayer player) {
    }

    @Override
    public void onUnload(EntityPlayer player) {
        if (!this.world.field_72995_K && this.craftMatrix != null) {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemstack = this.craftMatrix.func_70304_b(i);
                if (itemstack == null) continue;
                player.func_71019_a(itemstack, false);
            }
        }
    }

    @Override
    public ItemStack transferStackInSlot(EntityPlayer player, Slot slot, StackableContainer.ContainerSlotInterface containerSlot) {
        ItemStack itemstack = null;
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            if (!this.container.mergeItemStack(this, itemstack1, 1, 10, false)) {
                return null;
            }
            slot.func_75220_a(itemstack1, itemstack);
            if (itemstack1.field_77994_a == 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.field_77994_a == itemstack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, itemstack1);
        }
        return itemstack;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawForeground(int mouseX, int mouseY) {
        this.gui.text(this, I18n.func_135052_a((String)"container.crafting", (Object[])new Object[0])).truncateString(this.guiWidth - 16).drawString(8, 6 + this.getOffset(), -12566464);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.gui.bindTexture(texture);
        this.gui.drawTexture(this, 0, this.getOffset(), this.guiWidth, this.guiHeight - 22, 0, 0);
    }

    @Override
    public String getId() {
        return "none";
    }

    public int getOffset() {
        if (this.container.layout.isTop(this.stackId)) {
            return 22;
        }
        return 0;
    }

    @Override
    public int getSlotCount() {
        return 10;
    }

    @Override
    public void static_saveInventories(EntityPlayer player, ArrayList<StackableContainer> containers) {
    }

    @Override
    public int getRowSize() {
        return 3;
    }

    public class CraftingContainerSlot
    extends SlotCrafting
    implements StackableContainer.ContainerSlotInterface {
        public int stackId;
        public EntityPlayer player;
        public boolean canEditInventory;

        public CraftingContainerSlot(EntityPlayer player, IInventory inventory, IInventory inventory2, int par2, int par3, int par4) {
            super(player, inventory, inventory2, par2, par3, par4);
            this.player = player;
            this.stackId = CraftingContainer.this.stackId;
            this.canEditInventory = true;
            if (inventory2 instanceof UniqueItemInventory) {
                String uuid = ((UniqueItemInventory)inventory2).getIdentifier();
                this.canEditInventory = UniqueItemData.get(player.field_70170_p).hasRequiredPermission(player, uuid, 2);
            }
        }

        @Override
        public Slot getSlot() {
            return this;
        }

        @Override
        public int getStackId() {
            return this.stackId;
        }

        public boolean func_82869_a(EntityPlayer player) {
            return this.canTakeStack(player, false);
        }

        @Override
        public boolean canTakeStack(EntityPlayer player, boolean forRightClick) {
            if (!this.canEditInventory) {
                return forRightClick;
            }
            String uuid = UniqueItem.getIdentifier(super.func_75211_c());
            if (uuid.equals("none") || forRightClick) {
                return true;
            }
            return !this.chainContains(uuid, true);
        }

        public ItemStack func_75211_c() {
            ItemStack stack = super.func_75211_c();
            if (stack != null && stack.func_77973_b() instanceof UniqueItem.UpdatableItem) {
                ((UniqueItem.UpdatableItem)stack.func_77973_b()).updateItemStack(this, stack);
            }
            return stack;
        }

        @Override
        public boolean chainContains(String uuid, boolean getOther) {
            return CraftingContainer.this.chainContains(uuid, getOther);
        }

        public CraftingContainer getContainer() {
            return CraftingContainer.this;
        }
    }

    public class CraftingContainerInventory
    extends InventoryCrafting {
        public CraftingContainerInventory(Container par1Container, int par2, int par3) {
            super(par1Container, par2, par3);
        }

        public CraftingContainer getContainer() {
            return CraftingContainer.this;
        }
    }

    public class CraftingContainerCallbackContainer
    extends Container {
        public boolean func_75145_c(EntityPlayer entityplayer) {
            return true;
        }

        public void func_75130_a(IInventory par1IInventory) {
            if (CraftingContainer.this.craftMatrix == null) {
                return;
            }
            CraftingContainer.this.craftResult.func_70299_a(0, CraftingManager.func_77594_a().func_82787_a(CraftingContainer.this.craftMatrix, CraftingContainer.this.world));
        }
    }
}

