/*
 * Decompiled with CFR 0.152.
 */
package brad16840.core;

import brad16840.core.ClassTransformer;
import java.util.ArrayList;
import java.util.ListIterator;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ObfuscationHelper {

    public static class FieldPattern
    implements Pattern {
        public ClassTransformer.Obfuscation field;

        public FieldPattern(ClassTransformer.Obfuscation field) {
            this.field = field;
        }

        @Override
        public boolean matches(AbstractInsnNode instruction) {
            if (instruction == null || !(instruction instanceof FieldInsnNode)) {
                return false;
            }
            if (instruction.getOpcode() != 180) {
                return false;
            }
            return ((FieldInsnNode)instruction).name.equals(this.field.toString());
        }
    }

    public static class VariablePattern
    implements Pattern {
        public int variableNumber;

        public VariablePattern(int variableNumber) {
            this.variableNumber = variableNumber;
        }

        @Override
        public boolean matches(AbstractInsnNode instruction) {
            if (instruction == null || !(instruction instanceof VarInsnNode)) {
                return false;
            }
            switch (instruction.getOpcode()) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    break;
                }
                default: {
                    return false;
                }
            }
            return ((VarInsnNode)instruction).var == this.variableNumber;
        }
    }

    public static class MethodPattern
    implements Pattern {
        public ClassTransformer.Obfuscation method;

        public MethodPattern(ClassTransformer.Obfuscation method) {
            this.method = method;
        }

        @Override
        public boolean matches(AbstractInsnNode instruction) {
            if (instruction == null || !(instruction instanceof MethodInsnNode)) {
                return false;
            }
            if (instruction.getOpcode() != 182 && instruction.getOpcode() != 184 && instruction.getOpcode() != 185) {
                return false;
            }
            return ((MethodInsnNode)instruction).name.equals(this.method.toString());
        }
    }

    public static class PatternFinder {
        public ArrayList<Pattern> patterns = new ArrayList();

        public void addVariable(int number) {
            this.patterns.add(new VariablePattern(number));
        }

        public void addField(ClassTransformer.Obfuscation o) {
            this.patterns.add(new FieldPattern(o));
        }

        public void addMethod(ClassTransformer.Obfuscation o) {
            this.patterns.add(new MethodPattern(o));
        }

        public ArrayList<AbstractInsnNode> find(InsnList list) {
            ArrayList<AbstractInsnNode> matches = new ArrayList<AbstractInsnNode>();
            ListIterator iterator = list.iterator();
            while (iterator.hasNext()) {
                AbstractInsnNode parser;
                AbstractInsnNode next = parser = (AbstractInsnNode)iterator.next();
                boolean match = true;
                for (int i = 0; i < this.patterns.size(); ++i) {
                    if (parser == null || !this.patterns.get(i).matches(parser)) {
                        match = false;
                        break;
                    }
                    next = parser;
                    parser = parser.getNext();
                }
                if (!match) continue;
                matches.add(next);
            }
            return matches;
        }
    }

    public static interface Pattern {
        public boolean matches(AbstractInsnNode var1);
    }
}

