/*
 * Decompiled with CFR 0.152.
 */
package com.arc.bloodarsenal.common.block;

import WayofTime.alchemicalWizardry.ModItems;
import WayofTime.alchemicalWizardry.api.items.IAltarManipulator;
import WayofTime.alchemicalWizardry.common.items.EnergyBattery;
import WayofTime.alchemicalWizardry.common.items.sigil.SigilOfHolding;
import com.arc.bloodarsenal.common.block.ModBlocks;
import com.arc.bloodarsenal.common.tileentity.TilePortableAltar;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class BlockPortableAltar
extends BlockContainer {
    @SideOnly(value=Side.CLIENT)
    private IIcon topIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon1;
    @SideOnly(value=Side.CLIENT)
    private IIcon sideIcon2;
    @SideOnly(value=Side.CLIENT)
    private IIcon bottomIcon;

    public BlockPortableAltar() {
        super(Material.field_151576_e);
        this.func_149711_c(7.0f);
        this.func_149752_b(10.0f);
        this.func_149663_c("portable_altar");
        this.func_149672_a(field_149780_i);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.topIcon = iconRegister.func_94245_a("AlchemicalWizardry:BloodAltar_Top");
        this.sideIcon1 = iconRegister.func_94245_a("AlchemicalWizardry:BloodAltar_SideType1");
        this.sideIcon2 = iconRegister.func_94245_a("AlchemicalWizardry:BloodAltar_SideType2");
        this.bottomIcon = iconRegister.func_94245_a("AlchemicalWizardry:BloodAltar_Bottom");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        switch (side) {
            case 0: {
                return this.bottomIcon;
            }
            case 1: {
                return this.topIcon;
            }
        }
        return this.sideIcon2;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        if (((Object)((Object)this)).equals((Object)ModBlocks.portable_altar)) {
            for (int i = 1; i <= 6; ++i) {
                ItemStack stack = new ItemStack(par1, 1, 0);
                NBTTagCompound tag = new NBTTagCompound();
                TilePortableAltar altar = new TilePortableAltar();
                NBTTagList tagList = new NBTTagList();
                NBTTagCompound savedTag = new NBTTagCompound();
                if (altar != null) {
                    altar.func_145841_b(savedTag);
                }
                tagList.func_74742_a((NBTBase)savedTag);
                tag.func_74768_a("currentEssence", 0);
                tag.func_74768_a("capacity", 10000);
                tag.func_74768_a("upgradeLevel", i);
                stack.func_77982_d(tag);
                par3List.add(stack);
            }
        } else {
            super.func_149666_a(par1, par2CreativeTabs, par3List);
        }
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int meta) {
        ItemStack stack;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePortableAltar && (stack = ((TilePortableAltar)tile).func_70301_a(0)) != null && stack.func_77973_b() instanceof EnergyBattery) {
            EnergyBattery bloodOrb = (EnergyBattery)stack.func_77973_b();
            int maxEssence = bloodOrb.getMaxEssence();
            int currentEssence = bloodOrb.getCurrentEssence(stack);
            int level = currentEssence * 15 / maxEssence;
            return Math.min(15, level) % 16;
        }
        return 0;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int idk, float what, float these, float are) {
        TilePortableAltar tileEntity = (TilePortableAltar)world.func_147438_o(x, y, z);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        ItemStack playerItem = player.func_71045_bC();
        if (playerItem != null) {
            if (playerItem.func_77973_b().equals(ModItems.divinationSigil)) {
                if (player.field_70170_p.field_72995_K) {
                    world.func_147471_g(x, y, z);
                } else {
                    tileEntity.sendChatInfoToPlayer(player);
                }
                return true;
            }
            if (playerItem.func_77973_b().equals(ModItems.itemSeerSigil)) {
                if (player.field_70170_p.field_72995_K) {
                    world.func_147471_g(x, y, z);
                } else {
                    tileEntity.sendMoreChatInfoToPlayer(player);
                }
                return true;
            }
            if (playerItem.func_77973_b() instanceof IAltarManipulator) {
                return false;
            }
            if (playerItem.func_77973_b().equals(ModItems.sigilOfHolding)) {
                ItemStack item = ((SigilOfHolding)playerItem.func_77973_b()).getCurrentItem(playerItem);
                if (item != null && item.func_77973_b().equals(ModItems.divinationSigil)) {
                    if (player.field_70170_p.field_72995_K) {
                        world.func_147471_g(x, y, z);
                    } else {
                        tileEntity.sendChatInfoToPlayer(player);
                    }
                    return true;
                }
                if (item != null && item.func_77973_b().equals(ModItems.itemSeerSigil)) {
                    if (player.field_70170_p.field_72995_K) {
                        world.func_147471_g(x, y, z);
                    } else {
                        tileEntity.sendMoreChatInfoToPlayer(player);
                    }
                    return true;
                }
            }
        }
        if (tileEntity.func_70301_a(0) == null && playerItem != null) {
            ItemStack newItem = playerItem.func_77946_l();
            newItem.field_77994_a = 1;
            --playerItem.field_77994_a;
            tileEntity.func_70299_a(0, newItem);
            tileEntity.startCycle();
        } else if (tileEntity.func_70301_a(0) != null && playerItem == null) {
            player.field_71071_by.func_70441_a(tileEntity.func_70301_a(0));
            tileEntity.func_70299_a(0, null);
            tileEntity.setActive(false);
        }
        world.func_147471_g(x, y, z);
        return true;
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        this.dropItems(world, x, y, z);
        super.func_149749_a(world, x, y, z, par5, par6);
    }

    private void dropItems(World world, int x, int y, int z) {
        Random rand = new Random();
        TileEntity tileEntity = world.func_147438_o(x, y, z);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack item = inventory.func_70301_a(i);
            if (item == null || item.field_77994_a <= 0) continue;
            float rx = rand.nextFloat() * 0.8f + 0.1f;
            float ry = rand.nextFloat() * 0.8f + 0.1f;
            float rz = rand.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rx), (double)((float)y + ry), (double)((float)z + rz), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rand.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rand.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack stack) {
        NBTTagCompound tag;
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePortableAltar && (tag = stack.func_77978_p()) != null) {
            ((TilePortableAltar)tile).readNBTOnPlace(tag);
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePortableAltar) {
            ItemStack drop = new ItemStack((Block)this);
            NBTTagCompound tag = new NBTTagCompound();
            ((TilePortableAltar)tile).writeNBTOnHarvest(tag);
            drop.func_77982_d(tag);
            list.add(drop);
        }
        return list;
    }

    public void func_149681_a(World world, int x, int y, int z, int meta, EntityPlayer player) {
        if (!player.field_71075_bZ.field_75098_d) {
            this.func_149697_b(world, x, y, z, meta, 0);
        }
        super.func_149681_a(world, x, y, z, meta, player);
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149716_u() {
        return true;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        Item item = this.func_149694_d(world, x, y, z);
        if (item == null) {
            return null;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof TilePortableAltar) {
            ItemStack drop = new ItemStack((Block)this);
            NBTTagCompound tag = new NBTTagCompound();
            ((TilePortableAltar)tile).writeNBTOnHarvest(tag);
            drop.func_77982_d(tag);
            return drop;
        }
        return null;
    }

    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        TilePortableAltar tileEntity = (TilePortableAltar)world.func_147438_o(x, y, z);
        if (!tileEntity.isActive()) {
            return;
        }
        if (rand.nextInt(3) != 0) {
            return;
        }
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TilePortableAltar();
    }
}

