/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.util.LogCategory;
import ic2.core.util.StackUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public abstract class HandHeldInventory
implements IHasGui {
    protected final ItemStack containerStack;
    protected final ItemStack[] inventory;
    protected final EntityPlayer player;
    private boolean cleared;

    public HandHeldInventory(EntityPlayer player, ItemStack itemStack1, int inventorySize) {
        this.containerStack = itemStack1;
        this.inventory = new ItemStack[inventorySize];
        this.player = player;
        if (IC2.platform.isSimulating()) {
            NBTTagCompound nbt = StackUtil.getOrCreateNbtData(itemStack1);
            nbt.func_74768_a("uid", IC2.random.nextInt());
            NBTTagList contentList = nbt.func_150295_c("Items", 10);
            for (int i = 0; i < contentList.func_74745_c(); ++i) {
                NBTTagCompound slotNbt = contentList.func_150305_b(i);
                byte slot = slotNbt.func_74771_c("Slot");
                if (slot < 0 || slot >= this.inventory.length) continue;
                this.inventory[slot] = ItemStack.func_77949_a((NBTTagCompound)slotNbt);
            }
        }
    }

    public int func_70302_i_() {
        return this.inventory.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory[i];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack ret;
        if (this.inventory[slot] == null) {
            return null;
        }
        if (this.inventory[slot].field_77994_a <= amount) {
            ret = this.inventory[slot];
            this.inventory[slot] = null;
        } else {
            ret = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a <= 0) {
                this.inventory[slot] = null;
            }
        }
        this.save();
        return ret;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.save();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack1) {
        return false;
    }

    public void func_70296_d() {
        this.save();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player == this.player && this.getPlayerInventoryIndex() >= -1;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
        this.save();
    }

    public boolean isThisContainer(ItemStack stack) {
        if (stack == null || stack.func_77973_b() != this.containerStack.func_77973_b()) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt != null && nbt.func_74762_e("uid") == this.getUid();
    }

    protected int getUid() {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(this.containerStack);
        return nbt.func_74762_e("uid");
    }

    protected int getPlayerInventoryIndex() {
        for (int i = -1; i < this.player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack;
            ItemStack itemStack = stack = i == -1 ? this.player.field_71071_by.func_70445_o() : this.player.field_71071_by.func_70301_a(i);
            if (!this.isThisContainer(stack)) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    protected void save() {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        if (this.cleared) {
            return;
        }
        boolean dropItself = false;
        for (int i = 0; i < this.inventory.length; ++i) {
            if (!this.isThisContainer(this.inventory[i])) continue;
            this.inventory[i] = null;
            dropItself = true;
        }
        NBTTagList contentList = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbt);
            contentList.func_74742_a((NBTBase)nbt);
        }
        StackUtil.getOrCreateNbtData(this.containerStack).func_74782_a("Items", (NBTBase)contentList);
        this.containerStack.field_77994_a = 1;
        if (dropItself) {
            StackUtil.dropAsEntity(this.player.field_70170_p, (int)this.player.field_70165_t, (int)this.player.field_70163_u, (int)this.player.field_70161_v, this.containerStack);
            this.clear();
        } else {
            int idx = this.getPlayerInventoryIndex();
            if (idx < -1) {
                IC2.log.warn(LogCategory.Item, "Handheld inventory saving failed for player " + this.player.getDisplayName() + ".");
                this.clear();
            } else if (idx == -1) {
                this.player.field_71071_by.func_70437_b(this.containerStack);
            } else {
                this.player.field_71071_by.func_70299_a(idx, this.containerStack);
            }
        }
    }

    private void clear() {
        for (int i = 0; i < this.inventory.length; ++i) {
            this.inventory[i] = null;
        }
        this.cleared = true;
    }
}

