/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.tool;

import ic2.core.IC2;
import ic2.core.init.InternalName;
import ic2.core.item.tool.ItemElectricTool;
import java.util.EnumSet;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class ItemDrill
extends ItemElectricTool {
    protected int soundTicker = 0;

    public ItemDrill(InternalName internalName, int operationEnergyCost, ItemElectricTool.HarvestLevel harvestLevel) {
        super(internalName, operationEnergyCost, harvestLevel, EnumSet.of(ItemElectricTool.ToolClass.Pickaxe, ItemElectricTool.ToolClass.Shovel));
    }

    @Override
    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float xOffset, float yOffset, float zOffset) {
        for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
            Item item;
            ItemStack torchStack = player.field_71071_by.field_70462_a[i];
            if (torchStack == null || !torchStack.func_77977_a().toLowerCase(Locale.ENGLISH).contains("torch") || !((item = torchStack.func_77973_b()) instanceof ItemBlock)) continue;
            int oldMeta = torchStack.func_77960_j();
            int oldSize = torchStack.field_77994_a;
            boolean result = torchStack.func_77943_a(player, world, x, y, z, side, xOffset, yOffset, zOffset);
            if (player.field_71075_bZ.field_75098_d) {
                torchStack.func_77964_b(oldMeta);
                torchStack.field_77994_a = oldSize;
            } else if (torchStack.field_77994_a <= 0) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)torchStack);
                player.field_71071_by.field_70462_a[i] = null;
            }
            if (!result) continue;
            return true;
        }
        return super.func_77648_a(stack, player, world, x, y, z, side, xOffset, yOffset, zOffset);
    }

    @Override
    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        float rStrength = super.getDigSpeed(stack, block, meta);
        if (rStrength > 1.0f) {
            ++this.soundTicker;
            if (this.soundTicker % 4 == 0) {
                IC2.platform.playSoundSp(this.getRandomDrillSound(), 1.0f, 1.0f);
            }
        }
        return rStrength;
    }

    public String getRandomDrillSound() {
        switch (IC2.random.nextInt(4)) {
            default: {
                return "drill";
            }
            case 1: {
                return "drillOne";
            }
            case 2: {
                return "drillTwo";
            }
            case 3: 
        }
        return "drillThree";
    }
}

