/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.common.features;

import appeng.core.FacadeConfig;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraftforge.common.config.Property;
import thaumcraft.common.config.Config;
import thaumcraft.common.config.ConfigBlocks;
import thaumicenergistics.api.IThEConfig;
import thaumicenergistics.common.features.CommonDependantItems;
import thaumicenergistics.common.features.ThEDependencyFeatureBase;

public class FeatureThaumcraftFacades
extends ThEDependencyFeatureBase {
    private final Pattern sanitizer = Pattern.compile("[^a-zA-Z0-9]");

    private void forceEnabled(Block block, int meta) {
        if (block == null) {
            return;
        }
        GameRegistry.UniqueIdentifier uid = GameRegistry.findUniqueIdentifierFor((Block)block);
        if (uid == null) {
            return;
        }
        String modName = this.sanitizer.matcher(uid.modId).replaceAll("");
        String blockName = this.sanitizer.matcher(uid.name).replaceAll("");
        Property prop = FacadeConfig.instance.get(modName, blockName + (meta == 0 ? "" : "." + meta), true);
        prop.set(true);
    }

    @Override
    protected boolean checkConfigs(IThEConfig theConfig) {
        return theConfig.forceTCFacades();
    }

    @Override
    protected Object[] getItemReqs(CommonDependantItems cdi) {
        return null;
    }

    @Override
    protected void registerAdditional() {
        super.registerAdditional();
        this.forceEnabled(ConfigBlocks.blockCosmeticOpaque, 0);
        this.forceEnabled(ConfigBlocks.blockCosmeticOpaque, 1);
        if (Config.allowMirrors) {
            this.forceEnabled(ConfigBlocks.blockCosmeticOpaque, 2);
        }
        this.forceEnabled(ConfigBlocks.blockCosmeticSolid, 1);
        this.forceEnabled(ConfigBlocks.blockCosmeticSolid, 4);
        this.forceEnabled(ConfigBlocks.blockCosmeticSolid, 5);
        this.forceEnabled(ConfigBlocks.blockCosmeticSolid, 6);
        this.forceEnabled(ConfigBlocks.blockCosmeticSolid, 7);
        this.forceEnabled(ConfigBlocks.blockCosmeticSolid, 11);
        this.forceEnabled(ConfigBlocks.blockCosmeticSolid, 12);
        this.forceEnabled(ConfigBlocks.blockCosmeticSolid, 14);
        this.forceEnabled(ConfigBlocks.blockWoodenDevice, 6);
        this.forceEnabled(ConfigBlocks.blockWoodenDevice, 7);
        this.forceEnabled(ConfigBlocks.blockTaint, 0);
        this.forceEnabled(ConfigBlocks.blockTaint, 2);
    }

    @Override
    protected void registerCrafting(CommonDependantItems cdi) {
    }
}

