/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.multiblock;

import cofh.thermaldynamics.multiblock.IMultiBlockRoute;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.multiblock.RouteCache;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.world.World;

public abstract class MultiBlockGridWithRoutes
extends MultiBlockGrid {
    public HashMap<IMultiBlockRoute, RouteCache> routeCacheMap = new HashMap();
    public final LinkedList<RouteCache> calculatingRoutes = new LinkedList();

    public MultiBlockGridWithRoutes(World world) {
        super(world);
    }

    @Override
    public void doTickProcessing(long l) {
        int n = 0;
        while (!this.calculatingRoutes.isEmpty()) {
            RouteCache routeCache = this.calculatingRoutes.peek();
            if (routeCache != null && !routeCache.processStep()) {
                this.calculatingRoutes.remove(routeCache);
            }
            if (n == 15) {
                if (System.nanoTime() > l) {
                    return;
                }
                n = 0;
            }
            ++n;
        }
    }

    @Override
    public boolean isTickProcessing() {
        return !this.calculatingRoutes.isEmpty();
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
        this.onMajorGridChange();
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        if (!this.routeCacheMap.isEmpty()) {
            for (RouteCache routeCache : this.routeCacheMap.values()) {
                routeCache.invalidate();
            }
            this.routeCacheMap.clear();
        }
        if (!this.calculatingRoutes.isEmpty()) {
            this.calculatingRoutes.clear();
        }
    }

    public RouteCache getRoutesFromOutputNonUrgent(IMultiBlockRoute iMultiBlockRoute) {
        RouteCache routeCache = this.routeCacheMap.get(iMultiBlockRoute);
        if (routeCache != null) {
            return routeCache;
        }
        routeCache = new RouteCache(iMultiBlockRoute);
        this.calculatingRoutes.add(routeCache);
        this.routeCacheMap.put(iMultiBlockRoute, routeCache);
        return routeCache;
    }

    public RouteCache getRoutesFromOutputRange(IMultiBlockRoute iMultiBlockRoute, int n) {
        RouteCache routeCache = this.routeCacheMap.get(iMultiBlockRoute);
        if (routeCache == null) {
            routeCache = new RouteCache(iMultiBlockRoute, n);
            routeCache.generateCache();
            this.routeCacheMap.put(iMultiBlockRoute, routeCache);
        } else if (routeCache.maxPathLength < n) {
            routeCache.maxPathLength = n;
            routeCache.generateCache();
        }
        return routeCache;
    }

    public RouteCache getRoutesFromOutput(IMultiBlockRoute iMultiBlockRoute) {
        RouteCache routeCache = this.routeCacheMap.get(iMultiBlockRoute);
        if (routeCache == null) {
            routeCache = new RouteCache(iMultiBlockRoute);
            routeCache.generateCache();
            this.routeCacheMap.put(iMultiBlockRoute, routeCache);
        } else if (!routeCache.isFinishedGenerating() || routeCache.maxPathLength < Integer.MAX_VALUE) {
            routeCache.maxPathLength = Integer.MAX_VALUE;
            routeCache.generateCache();
        }
        return routeCache;
    }
}

