/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.render;

import cofh.core.render.RenderUtils;
import cofh.lib.render.RenderHelper;
import cofh.repack.codechicken.lib.render.CCRenderState;
import cofh.repack.codechicken.lib.vec.Translation;
import cofh.repack.codechicken.lib.vec.Vector3;
import cofh.thermaldynamics.duct.BlockDuct;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.render.RenderDuct;
import com.google.common.collect.Iterators;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Iterator;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class RenderDuctItems
extends TileEntitySpecialRenderer {
    public static final int ITEMS_TO_RENDER_PER_DUCT = 16;
    static RenderItem travelingItemRender;
    static EntityItem travelingEntityItem;
    static float travelingItemSpin;
    public static final RenderDuctItems instance;
    static final float ITEM_RENDER_SCALE = 0.6f;
    public static float spinStep;

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent clientTickEvent) {
        travelingItemSpin += spinStep;
        travelingItemSpin %= 180.0f;
    }

    public void func_147500_a(TileEntity tileEntity, double d, double d2, double d3, float f) {
        TileItemDuct tileItemDuct = (TileItemDuct)tileEntity;
        this.renderItemDuct(tileItemDuct, d, d2, d3, f);
    }

    public void renderItemDuct(TileItemDuct tileItemDuct, double d, double d2, double d3, float f) {
        if (!tileItemDuct.myItems.isEmpty() || !tileItemDuct.itemsToAdd.isEmpty()) {
            RenderUtils.preWorldRender((IBlockAccess)tileItemDuct.func_145831_w(), (int)((TileEntity)tileItemDuct).field_145851_c, (int)((TileEntity)tileItemDuct).field_145848_d, (int)((TileEntity)tileItemDuct).field_145849_e);
            CCRenderState.useNormals = true;
            this.renderTravelingItems(Iterators.concat(tileItemDuct.itemsToAdd.iterator(), tileItemDuct.myItems.iterator()), tileItemDuct, tileItemDuct.func_145831_w(), d, d2, d3, f);
            CCRenderState.useNormals = false;
            CCRenderState.reset();
        }
        if (tileItemDuct.centerLine > 0) {
            GL11.glPushMatrix();
            Translation translation = new Vector3(d, d2, d3).translation();
            CCRenderState.reset();
            GL11.glEnable((int)3008);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            CCRenderState.useNormals = true;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            GL11.glEnable((int)3042);
            GL11.glEnable((int)2884);
            GL11.glBlendFunc((int)770, (int)1);
            RenderHelper.bindTexture((ResourceLocation)RenderHelper.MC_BLOCK_SHEET);
            RenderUtils.preWorldRender((IBlockAccess)tileItemDuct.func_145831_w(), (int)((TileEntity)tileItemDuct).field_145851_c, (int)((TileEntity)tileItemDuct).field_145848_d, (int)((TileEntity)tileItemDuct).field_145849_e);
            CCRenderState.setColour((int)-1);
            CCRenderState.setBrightness((int)0xF000F0);
            RenderDuct.instance.getDuctConnections(tileItemDuct);
            CCRenderState.startDrawing();
            for (int i = 0; i < 6; ++i) {
                if (BlockDuct.ConnectionTypes.values()[RenderDuct.connections[i]].renderDuct() && tileItemDuct.centerLineSub[i] != 0) {
                    CCRenderState.alphaOverride = RenderDuctItems.getAlphaLevel(tileItemDuct.centerLineSub[i], f);
                    RenderDuct.modelLine[i].render(new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)RenderDuct.textureCenterLine)});
                    continue;
                }
                CCRenderState.alphaOverride = RenderDuctItems.getAlphaLevel(tileItemDuct.centerLine, f);
                RenderDuct.modelLineCenter.render(i * 4, i * 4 + 4, new CCRenderState.IVertexOperation[]{translation, RenderUtils.getIconTransformation((IIcon)RenderDuct.textureCenterLine)});
            }
            CCRenderState.draw();
            CCRenderState.alphaOverride = -1;
            CCRenderState.reset();
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glDisable((int)3042);
            GL11.glEnable((int)2896);
            CCRenderState.useNormals = false;
            GL11.glPopMatrix();
        }
    }

    public static int getAlphaLevel(int n, float f) {
        return (int)Math.min(80.0, 0.7 * ((double)((float)n - f) * 255.0) / 10.0);
    }

    public void renderTravelingItems(Iterator<TravelingItem> iterator, TileItemDuct tileItemDuct, World world, double d, double d2, double d3, float f) {
        if (!iterator.hasNext()) {
            return;
        }
        RenderDuctItems.travelingEntityItem.field_70290_d = travelingItemSpin + f * spinStep;
        GL11.glPushMatrix();
        GL11.glTranslated((double)(d + 0.5), (double)(d2 + 0.5), (double)(d3 + 0.5));
        for (int i = 0; iterator.hasNext() && i < 16; ++i) {
            TravelingItem travelingItem = iterator.next();
            if (travelingItem == null || travelingItem.stack == null) continue;
            double d4 = ((float)travelingItem.progress + f * (float)travelingItem.step) / (float)tileItemDuct.getPipeLength();
            if (travelingItem.shouldDie && (d4 -= 0.5) > 0.0) continue;
            GL11.glPushMatrix();
            if (d4 < 0.0) {
                this.translateItem(travelingItem.oldDirection, d4);
            } else {
                this.translateItem(travelingItem.direction, d4);
            }
            GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
            travelingEntityItem.func_92058_a(travelingItem.stack);
            travelingItemRender.func_76986_a(travelingEntityItem, 0.0, (double)-0.1f, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }
        GL11.glPopMatrix();
    }

    private void translateItem(byte by, double d) {
        GL11.glTranslated((double)((double)Facing.field_71586_b[by] * d), (double)((double)Facing.field_71587_c[by] * d), (double)((double)Facing.field_71585_d[by] * d));
    }

    static {
        travelingEntityItem = new EntityItem(null);
        travelingItemSpin = 0.25f;
        instance = new RenderDuctItems();
        travelingItemRender = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        travelingItemRender.func_76976_a(RenderManager.field_78727_a);
        RenderDuctItems.travelingEntityItem.field_70290_d = 0.0f;
        FMLCommonHandler.instance().bus().register((Object)instance);
        spinStep = 0.026175f;
    }
}

