/*
 * Decompiled with CFR 0.152.
 */
package travellersgear.common.network;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import travellersgear.TravellersGear;
import travellersgear.common.network.MessageNBTSync;

public class MessageOpenGui
implements IMessage {
    int dim;
    int playerid;
    int guiid;

    public MessageOpenGui() {
    }

    public MessageOpenGui(EntityPlayer player, int guiid) {
        this.dim = player.field_70170_p.field_73011_w.field_76574_g;
        this.playerid = player.func_145782_y();
        this.guiid = guiid;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.playerid);
        buf.writeInt(this.guiid);
    }

    public void fromBytes(ByteBuf buf) {
        this.dim = buf.readInt();
        this.playerid = buf.readInt();
        this.guiid = buf.readInt();
    }

    public static class HandlerServer
    implements IMessageHandler<MessageOpenGui, IMessage> {
        public IMessage onMessage(MessageOpenGui message, MessageContext ctx) {
            WorldServer world = DimensionManager.getWorld((int)message.dim);
            if (world == null) {
                return null;
            }
            EntityPlayerMP ent = ctx.getServerHandler().field_147369_b;
            if (!(ent instanceof EntityPlayer)) {
                return null;
            }
            EntityPlayer player = (EntityPlayer)ent;
            TravellersGear.packetHandler.sendToAll((IMessage)new MessageNBTSync(player));
            boolean hasServerGui = TravellersGear.proxy.getServerGuiElement(message.guiid, player, (World)world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v) != null;
            player.openGui((Object)TravellersGear.instance, message.guiid, player.field_70170_p, MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
            return hasServerGui ? null : new MessageOpenGui(player, message.guiid);
        }
    }

    public static class HandlerClient
    implements IMessageHandler<MessageOpenGui, IMessage> {
        public IMessage onMessage(MessageOpenGui message, MessageContext ctx) {
            Minecraft.func_71410_x().field_71439_g.openGui((Object)TravellersGear.instance, message.guiid, Minecraft.func_71410_x().field_71439_g.field_70170_p, MathHelper.func_76128_c((double)Minecraft.func_71410_x().field_71439_g.field_70165_t), MathHelper.func_76128_c((double)Minecraft.func_71410_x().field_71439_g.field_70163_u), MathHelper.func_76128_c((double)Minecraft.func_71410_x().field_71439_g.field_70161_v));
            return null;
        }
    }
}

