/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.render.radar.EntityIconDefinitions;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.resource.EntityIconDefinition;
import xaero.common.minimap.render.radar.resource.EntityIconModelConfig;

public class EntityIconManager {
    private EntityIconPrerenderer prerenderer;
    private Map<String, EntityIconDefinition> iconDefinitions;
    private Map<String, Integer> cachedTextures;
    private Map<String, Integer> cachedResourceTextures;
    private boolean canPrerender;
    private Gson gson;
    private StringBuilder entityStringBuilder;
    private EntityIconModelConfig defaultModelConfig;

    public EntityIconManager(EntityIconPrerenderer prerenderer) {
        this.prerenderer = prerenderer;
        this.iconDefinitions = new HashMap<String, EntityIconDefinition>();
        this.cachedTextures = new HashMap<String, Integer>();
        this.cachedResourceTextures = new HashMap<String, Integer>();
        this.gson = new Gson();
        this.resetResources();
        this.entityStringBuilder = new StringBuilder();
        this.defaultModelConfig = new EntityIconModelConfig();
    }

    public <T extends Entity> int getEntityHeadTexture(T entity, Framebuffer defaultFramebuffer, MinimapRendererHelper helper, float scale, boolean[] spriteBased, boolean debug, boolean debugEntityVariantIds) {
        EntityLivingBase livingEntity;
        ItemStack headItemStack;
        String entityId = EntityList.func_75621_b(entity);
        EntityIconDefinition iconDefinition = this.iconDefinitions.get(entityId);
        RenderManager renderManager = RenderManager.field_78727_a;
        Render entityRenderer = renderManager.func_78713_a(entity);
        StringBuilder entityStringBuilder = this.entityStringBuilder;
        entityStringBuilder.setLength(0);
        boolean variantIdAppended = false;
        if (iconDefinition != null) {
            Method variantIdBuilderMethod = iconDefinition.getVariantIdBuilderMethod();
            if (variantIdBuilderMethod != null) {
                try {
                    variantIdBuilderMethod.invoke(null, entityStringBuilder, entityRenderer, entity);
                    variantIdAppended = true;
                }
                catch (Throwable e) {
                    System.out.println("Exception while using the variant builder ID method " + iconDefinition.getVariantIdBuilderMethodString() + " defined for " + entityId);
                    System.out.println("If the exception is on another mod's end, suppressing it here could lead to more issues. Please report to appropriate mod devs.");
                    e.printStackTrace();
                    iconDefinition.setVariantIdBuilderMethod(null);
                }
            } else {
                Method variantOldIdMethod = iconDefinition.getOldVariantIdMethod();
                if (variantOldIdMethod != null) {
                    try {
                        String entityVariantString = (String)variantOldIdMethod.invoke(null, entityRenderer, entity);
                        entityStringBuilder.append(entityVariantString);
                        variantIdAppended = true;
                    }
                    catch (Throwable e) {
                        System.out.println("Exception while using the variant ID method " + iconDefinition.getOldVariantIdMethodString() + " defined for " + entityId);
                        System.out.println("If the exception is on another mod's end, suppressing it here could lead to more issues. Please report to appropriate mod devs.");
                        e.printStackTrace();
                        iconDefinition.setOldVariantIdMethod(null);
                    }
                }
            }
        }
        if (!variantIdAppended) {
            EntityIconDefinitions.buildVariantIdString(entityStringBuilder, entityRenderer, entity);
        }
        while (GL11.glGetError() != 0) {
        }
        String entityVariantString = entityStringBuilder.toString();
        entityStringBuilder.append("%").append(entityId);
        if (entity instanceof EntityLivingBase && (headItemStack = (livingEntity = (EntityLivingBase)entity).func_71124_b(4)) != null) {
            entityStringBuilder.append("%").append(Item.field_150901_e.func_148750_c((Object)headItemStack.func_77973_b()));
        }
        String cacheKey = entityStringBuilder.toString();
        Integer cachedValue = this.cachedTextures.get(cacheKey);
        spriteBased[0] = false;
        if (cachedValue == null) {
            cachedValue = this.cachedResourceTextures.get(cacheKey);
            if (cachedValue == null) {
                ResourceLocation iconType;
                if (debugEntityVariantIds) {
                    Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText(entityVariantString));
                }
                String variantMapKey = entityVariantString;
                if (iconDefinition != null) {
                    iconType = iconDefinition.getVariantType(variantMapKey);
                    if (iconType == null) {
                        variantMapKey = "default";
                        iconType = iconDefinition.getVariantType(variantMapKey);
                    }
                } else {
                    iconType = EntityIconDefinition.MODEL_TYPE;
                }
                if (iconType == EntityIconDefinition.MODEL_TYPE) {
                    if (this.canPrerender) {
                        EntityIconModelConfig variantModelConfig;
                        EntityIconModelConfig modelConfig = this.defaultModelConfig;
                        EntityIconModelConfig entityIconModelConfig = variantModelConfig = iconDefinition == null ? null : iconDefinition.getModelConfig(variantMapKey);
                        if (variantModelConfig != null) {
                            modelConfig = variantModelConfig;
                        }
                        cachedValue = this.prerenderer.prerender(entityRenderer, entity, defaultFramebuffer, helper, scale, modelConfig, debug);
                        this.cachedTextures.put(cacheKey, cachedValue);
                        if (cachedValue != -1) {
                            this.canPrerender = false;
                        }
                    } else {
                        cachedValue = -1;
                    }
                } else if (iconType == EntityIconDefinition.DOT_TYPE) {
                    cachedValue = -1;
                    this.cachedTextures.put(cacheKey, cachedValue);
                } else {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(iconType);
                    GL11.glTexParameteri((int)3553, (int)33085, (int)3);
                    GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
                    GL11.glTexParameterf((int)3553, (int)33083, (float)3.0f);
                    GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
                    GL11.glTexParameteri((int)3553, (int)10241, (int)9985);
                    GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                    GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                    GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                    this.prerenderer.generateMipmaps();
                    cachedValue = GL11.glGetInteger((int)32873);
                    this.cachedResourceTextures.put(cacheKey, cachedValue);
                    spriteBased[0] = true;
                }
            } else {
                spriteBased[0] = true;
            }
        }
        return cachedValue;
    }

    public void reset() {
        for (Integer value : this.cachedTextures.values()) {
            if (value == null || value <= 0) continue;
            GL11.glDeleteTextures((int)value);
        }
        this.cachedTextures.clear();
        System.out.println("Entity icon manager reset!");
    }

    public void resetResources() {
        System.out.println("Reloading entity icon resources...");
        Set entityIds = EntityList.func_151515_b();
        Gson gson = this.gson;
        int attempts = 5;
        for (int i = 0; i < attempts; ++i) {
            try {
                this.resetResourcesAttempt(gson, entityIds);
                break;
            }
            catch (IOException ioe) {
                if (i != attempts - 1) continue;
                throw new RuntimeException(ioe);
            }
        }
        System.out.println("Done!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetResourcesAttempt(Gson gson, Set<String> entityIds) throws IOException {
        this.cachedResourceTextures.clear();
        this.iconDefinitions.clear();
        Iterator<String> iterator = entityIds.iterator();
        while (iterator.hasNext()) {
            IResource resource;
            String entityDefinitionJson;
            BufferedReader reader;
            InputStream resourceInput;
            String id;
            block15: {
                String[] entityIdSplit;
                block14: {
                    id = iterator.next();
                    resourceInput = null;
                    reader = null;
                    entityDefinitionJson = null;
                    resource = null;
                    entityIdSplit = id.split(":");
                    if (entityIdSplit.length <= 2) break block14;
                    System.out.println("Weird entity id skipped: " + id);
                    if (reader != null) {
                        reader.close();
                    }
                    if (resourceInput == null) continue;
                    resourceInput.close();
                }
                try {
                    resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation("xaerominimap", "entity/icon/definition/" + (entityIdSplit.length == 1 ? id : entityIdSplit[0] + "/" + entityIdSplit[1]) + ".json"));
                    break block15;
                }
                catch (FileNotFoundException fnfe) {
                    if (reader != null) {
                        reader.close();
                    }
                    if (resourceInput == null) continue;
                    resourceInput.close();
                }
                continue;
            }
            if (resource == null) continue;
            {
                resourceInput = resource.func_110527_b();
                reader = new BufferedReader(new InputStreamReader(resourceInput));
                final StringBuilder stringBuilder = new StringBuilder();
                reader.lines().forEach(new Consumer<String>(){

                    @Override
                    public void accept(String line) {
                        stringBuilder.append(line);
                        stringBuilder.append('\n');
                    }
                });
                entityDefinitionJson = stringBuilder.toString();
            }
            try {
                EntityIconDefinition entityIconDefinition = (EntityIconDefinition)gson.fromJson(entityDefinitionJson, EntityIconDefinition.class);
                entityIconDefinition.onConstruct(id);
                this.iconDefinitions.put(id, entityIconDefinition);
            }
            catch (JsonSyntaxException jse) {
                System.out.println("Json syntax exception when loading the entity icon definition for " + id + ".");
                jse.printStackTrace();
            }
        }
    }

    public void allowPrerender() {
        this.canPrerender = true;
    }

    public void onModelPartRenderDetection(ModelRenderer modelRenderer) {
        this.prerenderer.onModelPartRenderDetection(modelRenderer);
    }
}

