/*
 * Decompiled with CFR 0.152.
 */
package xaero.map;

import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.BlockDoublePlant;
import net.minecraft.block.BlockFlower;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.BlockOre;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import xaero.common.misc.OptimizedMath;
import xaero.map.BlockPos;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.biome.MapBiomes;
import xaero.map.biome.WriterBiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.core.XaeroWorldMapCore;
import xaero.map.exception.SilentException;
import xaero.map.misc.Misc;
import xaero.map.region.MapBlock;
import xaero.map.region.MapRegion;
import xaero.map.region.MapTile;
import xaero.map.region.MapTileChunk;
import xaero.map.region.OverlayBuilder;
import xaero.map.region.OverlayManager;

public class MapWriter {
    public static final String[] DEFAULT_RESOURCE = new String[]{"minecraft", ""};
    private int X;
    private int Z;
    private int playerChunkX;
    private int playerChunkZ;
    private int loadDistance;
    private int startTileChunkX;
    private int startTileChunkZ;
    private int endTileChunkX;
    private int endTileChunkZ;
    private int insideX;
    private int insideZ;
    private long updateCounter;
    private boolean clearCachedColours;
    private MapBlock loadingObject = new MapBlock();
    private OverlayBuilder overlayBuilder;
    private BlockPos mutableLocalPos;
    private BlockPos mutableGlobalPos;
    private int[] biomeBuffer;
    private long lastWrite = -1L;
    private long lastWriteTry = -1L;
    private int workingFrameCount;
    private long framesFreedTime = -1L;
    public long writeFreeSinceLastWrite = -1L;
    private int writeFreeSizeTiles;
    private int writeFreeFullUpdateTargetTime;
    private BlockStateColorTypeCache colorTypeCache;
    private MapProcessor mapProcessor;
    private ArrayList<Integer> buggedStates;
    private WriterBiomeInfoSupplier writerBiomeInfoSupplier;
    private MapTileChunk rightChunk = null;
    private MapTileChunk bottomRightChunk = null;
    private HashMap<String, Integer> textureColours = new HashMap();
    private HashMap<Integer, Integer> blockColours = new HashMap();
    private int lastBlockStateForTextureColor = -1;
    private int lastBlockStateForTextureColorResult = -1;

    public MapWriter(OverlayManager overlayManager, BlockStateColorTypeCache colorTypeCache) {
        this.overlayBuilder = new OverlayBuilder(overlayManager);
        this.mutableLocalPos = new BlockPos();
        this.mutableGlobalPos = new BlockPos();
        this.biomeBuffer = new int[3];
        this.colorTypeCache = colorTypeCache;
        this.buggedStates = new ArrayList();
        this.writerBiomeInfoSupplier = new WriterBiomeInfoSupplier(this.mutableGlobalPos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onRender() {
        block22: {
            long before = System.nanoTime();
            try {
                if (WorldMap.crashHandler.getCrashedBy() != null) break block22;
                Object object = this.mapProcessor.renderThreadPauseSync;
                synchronized (object) {
                    if (!this.mapProcessor.isWritingPaused() && !this.mapProcessor.isWaitingForWorldUpdate() && this.mapProcessor.getMapSaveLoad().isRegionDetectionComplete() && this.mapProcessor.isCurrentMultiworldWritable()) {
                        if (this.mapProcessor.getWorld() == null || !this.mapProcessor.caveStartIsDetermined()) {
                            return;
                        }
                        if (this.mapProcessor.getCurrentWorldId() != null && !this.mapProcessor.ignoreWorld((World)this.mapProcessor.getWorld()) && (WorldMap.settings.updateChunks || WorldMap.settings.loadChunks)) {
                            long passed;
                            double playerZ;
                            double playerY;
                            double playerX;
                            Object object2 = this.mapProcessor.mainStuffSync;
                            synchronized (object2) {
                                if (this.mapProcessor.mainWorld != this.mapProcessor.getWorld()) {
                                    return;
                                }
                                playerX = this.mapProcessor.mainPlayerX;
                                playerY = this.mapProcessor.mainPlayerY;
                                playerZ = this.mapProcessor.mainPlayerZ;
                            }
                            XaeroWorldMapCore.ensureField();
                            int lengthX = this.endTileChunkX - this.startTileChunkX + 1;
                            int lengthZ = this.endTileChunkZ - this.startTileChunkZ + 1;
                            if (this.lastWriteTry == -1L) {
                                lengthX = 3;
                                lengthZ = 3;
                            }
                            int sizeTileChunks = lengthX * lengthZ;
                            int sizeTiles = sizeTileChunks * 4 * 4;
                            int sizeBasedTargetTime = sizeTiles * 1000 / 1500;
                            int fullUpdateTargetTime = Math.max(100, sizeBasedTargetTime);
                            long time = System.currentTimeMillis();
                            long l = passed = this.lastWrite == -1L ? 0L : time - this.lastWrite;
                            if (this.lastWriteTry == -1L || this.writeFreeSizeTiles != sizeTiles || this.writeFreeFullUpdateTargetTime != fullUpdateTargetTime || this.workingFrameCount > 30) {
                                this.framesFreedTime = time;
                                this.writeFreeSizeTiles = sizeTiles;
                                this.writeFreeFullUpdateTargetTime = fullUpdateTargetTime;
                                this.workingFrameCount = 0;
                            }
                            long sinceLastWrite = Math.min(passed, this.writeFreeSinceLastWrite);
                            if (this.framesFreedTime != -1L) {
                                sinceLastWrite = time - this.framesFreedTime;
                            }
                            long tilesToUpdate = Math.min(sinceLastWrite * (long)sizeTiles / (long)fullUpdateTargetTime, 100L);
                            if (this.lastWrite == -1L || tilesToUpdate != 0L) {
                                this.lastWrite = time;
                            }
                            if (tilesToUpdate != 0L) {
                                if (this.framesFreedTime == -1L) {
                                    int timeLimit = (int)(Math.min(sinceLastWrite, 50L) * 86960L);
                                    long writeStartNano = System.nanoTime();
                                    boolean loadChunks = WorldMap.settings.loadChunks;
                                    boolean updateChunks = WorldMap.settings.updateChunks;
                                    boolean ignoreHeightmaps = WorldMap.settings.ignoreHeightmaps;
                                    boolean flowers = WorldMap.settings.flowers;
                                    boolean detailedDebug = WorldMap.settings.detailed_debug;
                                    int i = 0;
                                    while ((long)i < tilesToUpdate) {
                                        this.writeMap((World)this.mapProcessor.getWorld(), playerX, playerY, playerZ, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug);
                                        if (System.nanoTime() - writeStartNano >= (long)timeLimit) break;
                                        ++i;
                                    }
                                    ++this.workingFrameCount;
                                } else {
                                    this.writeFreeSinceLastWrite = sinceLastWrite;
                                    this.framesFreedTime = -1L;
                                }
                            }
                            this.lastWriteTry = time;
                            int startRegionX = this.startTileChunkX >> 3;
                            int startRegionZ = this.startTileChunkZ >> 3;
                            int endRegionX = this.endTileChunkX >> 3;
                            int endRegionZ = this.endTileChunkZ >> 3;
                            for (int visitRegionX = startRegionX; visitRegionX <= endRegionX; ++visitRegionX) {
                                for (int visitRegionZ = startRegionZ; visitRegionZ <= endRegionZ; ++visitRegionZ) {
                                    MapRegion visitRegion = this.mapProcessor.getMapRegion(visitRegionX, visitRegionZ, false);
                                    if (visitRegion == null || visitRegion.getLoadState() != 2) continue;
                                    visitRegion.registerVisit();
                                }
                            }
                        }
                    }
                }
            }
            catch (Throwable e) {
                WorldMap.crashHandler.setCrashedBy(e);
            }
        }
    }

    private int getWriteDistance() {
        return Math.min(32, Minecraft.func_71410_x().field_71474_y.field_151451_c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeMap(World world, double playerX, double playerY, double playerZ, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug) {
        boolean onlyLoad = loadChunks && (!updateChunks || this.updateCounter % 5L != 0L);
        World world2 = world;
        synchronized (world2) {
            if (this.insideX == 0 && this.insideZ == 0) {
                this.playerChunkX = (int)Math.floor(playerX) >> 4;
                this.playerChunkZ = (int)Math.floor(playerZ) >> 4;
                this.loadDistance = this.getWriteDistance();
                this.startTileChunkX = this.playerChunkX - this.loadDistance >> 2;
                this.startTileChunkZ = this.playerChunkZ - this.loadDistance >> 2;
                this.endTileChunkX = this.playerChunkX + this.loadDistance >> 2;
                this.endTileChunkZ = this.playerChunkZ + this.loadDistance >> 2;
            }
            this.writeChunk(world, this.loadDistance, onlyLoad, loadChunks, updateChunks, ignoreHeightmaps, flowers, detailedDebug);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeChunk(World world, int distance, boolean onlyLoad, boolean loadChunks, boolean updateChunks, boolean ignoreHeightmaps, boolean flowers, boolean detailedDebug) {
        int result = 1;
        int tileChunkX = this.startTileChunkX + this.X;
        int tileChunkZ = this.startTileChunkZ + this.Z;
        int tileChunkLocalX = tileChunkX & 7;
        int tileChunkLocalZ = tileChunkZ & 7;
        int regionX = tileChunkX >> 3;
        int regionZ = tileChunkZ >> 3;
        MapRegion region = this.mapProcessor.getMapRegion(regionX, regionZ, true);
        MapTileChunk tileChunk = null;
        this.rightChunk = null;
        MapTileChunk bottomChunk = null;
        this.bottomRightChunk = null;
        Object object = region.writerThreadPauseSync;
        synchronized (object) {
            if (!region.isWritingPaused()) {
                boolean regionIsResting;
                boolean isProperLoadState;
                MapRegion mapRegion = region;
                synchronized (mapRegion) {
                    boolean bl = isProperLoadState = region.getLoadState() == 2;
                    if (isProperLoadState) {
                        region.registerVisit();
                    }
                    if (regionIsResting = region.isResting()) {
                        region.setBeingWritten(true);
                        tileChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ);
                        if (isProperLoadState && tileChunk == null) {
                            tileChunk = new MapTileChunk(region, tileChunkX, tileChunkZ);
                            region.setChunk(tileChunkLocalX, tileChunkLocalZ, tileChunk);
                            tileChunk.setLoadState((byte)2);
                        } else if (!(region.reloadHasBeenRequested() || region.recacheHasBeenRequested() || region.getLoadState() != 0 && region.getLoadState() != 4)) {
                            this.mapProcessor.getMapSaveLoad().requestLoad(region, "writing");
                        }
                    }
                }
                if (regionIsResting && isProperLoadState) {
                    if (tileChunk != null && tileChunk.getLoadState() == 2) {
                        if (!tileChunk.getLeafTexture().shouldUpload()) {
                            int caveStart = this.mapProcessor.getCaveStart();
                            int chunkX = tileChunkX * 4 + this.insideX;
                            int chunkZ = tileChunkZ * 4 + this.insideZ;
                            if (chunkX >= this.playerChunkX - distance && chunkX < this.playerChunkX + distance && chunkZ >= this.playerChunkZ - distance && chunkZ < this.playerChunkZ + distance) {
                                Chunk chunk = world.func_72964_e(chunkX, chunkZ);
                                MapTile mapTile = tileChunk.getTile(this.insideX, this.insideZ);
                                boolean chunkUpdated = false;
                                try {
                                    chunkUpdated = chunk != null && (mapTile == null || (Boolean)XaeroWorldMapCore.chunkCleanField.get(chunk) == false);
                                }
                                catch (IllegalAccessException | IllegalArgumentException e) {
                                    throw new RuntimeException(e);
                                }
                                if (chunkUpdated && chunk.field_76636_d) {
                                    boolean connectedToOthers = false;
                                    block10: for (int i = -1; i < 2; ++i) {
                                        for (int j = -1; j < 2; ++j) {
                                            Chunk neighbor;
                                            if (i == 0 && j == 0 || (neighbor = world.func_72964_e(chunkX + i, chunkZ + j)) == null || !neighbor.field_76636_d) continue;
                                            connectedToOthers = true;
                                            break block10;
                                        }
                                    }
                                    if (connectedToOthers && (mapTile == null && loadChunks || mapTile != null && updateChunks && !onlyLoad)) {
                                        if (mapTile == null) {
                                            mapTile = this.mapProcessor.getTilePool().get(this.mapProcessor.getCurrentDimension(), chunkX, chunkZ);
                                            tileChunk.setChanged(true);
                                        }
                                        MapTileChunk prevTileChunk = tileChunk.getNeighbourTileChunk(0, -1, this.mapProcessor, false);
                                        MapTileChunk prevTileChunkDiagonal = tileChunk.getNeighbourTileChunk(-1, -1, this.mapProcessor, false);
                                        MapTileChunk prevTileChunkHorisontal = tileChunk.getNeighbourTileChunk(-1, 0, this.mapProcessor, false);
                                        int sectionBasedHeight = this.getSectionBasedHeight(chunk, 64);
                                        MapTile bottomTile = this.insideZ < 3 ? tileChunk.getTile(this.insideX, this.insideZ + 1) : null;
                                        MapTile rightTile = this.insideX < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ) : null;
                                        boolean triedFetchingBottomChunk = false;
                                        boolean triedFetchingRightChunk = false;
                                        for (int x = 0; x < 16; ++x) {
                                            for (int z = 0; z < 16; ++z) {
                                                int startHeight;
                                                if (caveStart != -1) {
                                                    startHeight = caveStart;
                                                } else {
                                                    int mappedHeight = chunk.func_76611_b(x, z);
                                                    startHeight = ignoreHeightmaps || mappedHeight == -1 ? sectionBasedHeight : mappedHeight + 3;
                                                }
                                                MapBlock currentPixel = mapTile.isLoaded() ? mapTile.getBlock(x, z) : null;
                                                this.loadPixel(world, this.loadingObject, currentPixel, chunk, x, z, startHeight, 0, caveStart != -1, mapTile.wasWrittenOnce(), flowers);
                                                this.loadingObject.fixHeightType(x, z, mapTile, tileChunk, prevTileChunk, prevTileChunkDiagonal, prevTileChunkHorisontal, this.loadingObject.getHeight(), true);
                                                boolean equalsSlopesExcluded = this.loadingObject.equalsSlopesExcluded(currentPixel);
                                                boolean fullyEqual = this.loadingObject.equals(currentPixel, equalsSlopesExcluded);
                                                if (fullyEqual) continue;
                                                mapTile.setBlock(x, z, this.loadingObject);
                                                this.loadingObject = currentPixel != null ? currentPixel : new MapBlock();
                                                if (!equalsSlopesExcluded) {
                                                    boolean xEdge;
                                                    tileChunk.setChanged(true);
                                                    boolean zEdge = z == 15;
                                                    boolean bl = xEdge = x == 15;
                                                    if (zEdge) {
                                                        if (!triedFetchingBottomChunk && bottomTile == null && this.insideZ == 3 && tileChunkLocalZ < 7) {
                                                            bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                                                            triedFetchingBottomChunk = true;
                                                            MapTile mapTile2 = bottomTile = bottomChunk != null ? bottomChunk.getTile(this.insideX, 0) : null;
                                                            if (bottomTile != null) {
                                                                bottomChunk.setChanged(true);
                                                            }
                                                        }
                                                        if (bottomTile != null) {
                                                            bottomTile.getBlock(x, 0).setSlopeUnknown(true);
                                                            if (!xEdge) {
                                                                bottomTile.getBlock(x + 1, 0).setSlopeUnknown(true);
                                                            }
                                                        }
                                                        if (xEdge) {
                                                            this.updateBottomRightTile(region, tileChunk, bottomChunk, tileChunkLocalX, tileChunkLocalZ);
                                                        }
                                                    } else if (xEdge) {
                                                        if (!triedFetchingRightChunk && rightTile == null && this.insideX == 3 && tileChunkLocalX < 7) {
                                                            this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                                                            triedFetchingRightChunk = true;
                                                            MapTile mapTile3 = rightTile = this.rightChunk != null ? this.rightChunk.getTile(0, this.insideZ) : null;
                                                            if (rightTile != null) {
                                                                this.rightChunk.setChanged(true);
                                                            }
                                                        }
                                                        if (rightTile != null) {
                                                            rightTile.getBlock(0, z + 1).setSlopeUnknown(true);
                                                        }
                                                    }
                                                }
                                                result = 3;
                                            }
                                        }
                                        tileChunk.setTile(this.insideX, this.insideZ, mapTile);
                                        mapTile.setWrittenOnce(true);
                                        mapTile.setLoaded(true);
                                        try {
                                            XaeroWorldMapCore.chunkCleanField.set(chunk, true);
                                        }
                                        catch (IllegalAccessException | IllegalArgumentException e) {
                                            throw new RuntimeException(e);
                                        }
                                    }
                                }
                            }
                        }
                        if (!tileChunk.includeInSave()) {
                            region.setChunk(tileChunkX & 7, tileChunkZ & 7, null);
                            tileChunk = null;
                        }
                    }
                    if (tileChunk != null && this.insideX == 3 && this.insideZ == 3 && tileChunk.wasChanged()) {
                        tileChunk.updateBuffers(this.mapProcessor, detailedDebug);
                        result += 2;
                        if (bottomChunk == null && tileChunkLocalZ < 7) {
                            bottomChunk = region.getChunk(tileChunkLocalX, tileChunkLocalZ + 1);
                        }
                        if (this.rightChunk == null && tileChunkLocalX < 7) {
                            this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                        }
                        if (this.bottomRightChunk == null && tileChunkLocalX < 7 && tileChunkLocalZ < 7) {
                            this.bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                        }
                        if (bottomChunk != null && bottomChunk.wasChanged()) {
                            bottomChunk.updateBuffers(this.mapProcessor, detailedDebug);
                            bottomChunk.setChanged(false);
                            result += 2;
                        }
                        if (this.rightChunk != null && this.rightChunk.wasChanged()) {
                            this.rightChunk.setToUpdateBuffers(true);
                            this.rightChunk.setChanged(false);
                        }
                        if (this.bottomRightChunk != null && this.bottomRightChunk.wasChanged()) {
                            this.bottomRightChunk.setToUpdateBuffers(true);
                            this.bottomRightChunk.setChanged(false);
                        }
                        tileChunk.setChanged(false);
                    }
                }
            }
        }
        ++this.insideZ;
        if (this.insideZ > 3) {
            this.insideZ = 0;
            ++this.insideX;
            if (this.insideX > 3) {
                this.insideX = 0;
                ++this.Z;
                if (this.Z > this.endTileChunkZ - this.startTileChunkZ) {
                    this.Z = 0;
                    ++this.X;
                    if (this.X > this.endTileChunkX - this.startTileChunkX) {
                        this.X = 0;
                        ++this.updateCounter;
                    }
                }
            }
        }
    }

    public void updateBottomRightTile(MapRegion region, MapTileChunk tileChunk, MapTileChunk bottomChunk, int tileChunkLocalX, int tileChunkLocalZ) {
        MapTile bottomRightTile;
        MapTile mapTile = bottomRightTile = this.insideX < 3 && this.insideZ < 3 ? tileChunk.getTile(this.insideX + 1, this.insideZ + 1) : null;
        if (bottomRightTile == null) {
            if (this.insideX == 3 && tileChunkLocalX < 7) {
                if (this.insideZ == 3) {
                    if (tileChunkLocalZ < 7) {
                        this.bottomRightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ + 1);
                    }
                    MapTile mapTile2 = bottomRightTile = this.bottomRightChunk != null ? this.bottomRightChunk.getTile(0, 0) : null;
                    if (bottomRightTile != null) {
                        this.bottomRightChunk.setChanged(true);
                    }
                } else {
                    if (this.rightChunk == null) {
                        this.rightChunk = region.getChunk(tileChunkLocalX + 1, tileChunkLocalZ);
                    }
                    MapTile mapTile3 = bottomRightTile = this.rightChunk != null ? this.rightChunk.getTile(0, this.insideZ + 1) : null;
                    if (bottomRightTile != null) {
                        this.rightChunk.setChanged(true);
                    }
                }
            } else if (this.insideX != 3 && this.insideZ == 3 && tileChunkLocalZ < 7) {
                MapTile mapTile4 = bottomRightTile = bottomChunk != null ? bottomChunk.getTile(this.insideX + 1, 0) : null;
                if (bottomRightTile != null) {
                    bottomChunk.setChanged(true);
                }
            }
        }
        if (bottomRightTile != null) {
            bottomRightTile.getBlock(0, 0).setSlopeUnknown(true);
        }
    }

    public int getSectionBasedHeight(Chunk bchunk, int startY) {
        ExtendedBlockStorage searchedSection;
        int i;
        ExtendedBlockStorage[] sections = bchunk.func_76587_i();
        int playerSection = startY >> 4;
        int result = -1;
        for (i = playerSection; i < sections.length; ++i) {
            searchedSection = sections[i];
            if (searchedSection == null) continue;
            result = (i << 4) + 15;
        }
        if (playerSection > 0 && result == -1) {
            for (i = playerSection - 1; i >= 0; --i) {
                searchedSection = sections[i];
                if (searchedSection == null) continue;
                result = (i << 4) + 15;
                break;
            }
        }
        return result;
    }

    public int getBiomeColor(int type, BlockPos pos, MapTile tile, World world) {
        int i = 0;
        int j = 0;
        int k = 0;
        int total = 0;
        int initX = pos.getX();
        int initZ = pos.getZ();
        MapBiomes mapBiomes = this.mapProcessor.getMapBiomes();
        for (int o = -1; o < 2; ++o) {
            for (int p = -1; p < 2; ++p) {
                pos.setPos(initX + o, pos.getY(), initZ + p);
                int b = this.getBiomeAtPos(pos, tile);
                if (b == -1) continue;
                int l = 0;
                BiomeGenBase gen = BiomeGenBase.func_150568_d((int)b);
                if (gen == null) {
                    gen = world.field_73011_w.field_76578_c.func_76935_a(pos.getX(), pos.getZ());
                    b = gen.field_76756_M;
                }
                if (gen == null) continue;
                l = type == 0 ? mapBiomes.getBiomeGrassColour(b, gen, pos) : (type == 1 ? mapBiomes.getBiomeFoliageColour(b, gen, pos) : mapBiomes.getBiomeWaterColour(b, gen));
                i += l >> 16 & 0xFF;
                j += l >> 8 & 0xFF;
                k += l & 0xFF;
                ++total;
            }
        }
        pos.setPos(initX, pos.getY(), initZ);
        if (total == 0) {
            return -1;
        }
        return (i / total & 0xFF) << 16 | (j / total & 0xFF) << 8 | k / total & 0xFF;
    }

    public int getBiomeAtPos(BlockPos pos, MapTile centerTile) {
        MapTile tile;
        int tileX = pos.getX() >> 4;
        int tileZ = pos.getZ() >> 4;
        MapTile mapTile = tile = tileX == centerTile.getChunkX() && tileZ == centerTile.getChunkZ() ? centerTile : this.mapProcessor.getMapTile(tileX, tileZ);
        if (tile != null && tile.isLoaded()) {
            return tile.getBlock(pos.getX() & 0xF, pos.getZ() & 0xF).getBiome();
        }
        return -1;
    }

    public boolean isGlowing(Block b) {
        return (double)b.func_149750_m() >= 0.5;
    }

    public boolean shouldOverlay(Block b, int lightOpacity) {
        return b instanceof BlockLiquid && lightOpacity != 255 && lightOpacity != 0 || b.func_149701_w() == 1 && lightOpacity != 255 || b instanceof BlockGlass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInvisible(World world, Block b, int meta, int state, boolean flowers) {
        if (b.func_149645_b() == -1) {
            return true;
        }
        if (b == Blocks.field_150478_aa) {
            return true;
        }
        if (b == Blocks.field_150329_H) {
            return true;
        }
        if (b == Blocks.field_150398_cm) {
            return true;
        }
        if ((b instanceof BlockFlower || b instanceof BlockDoublePlant) && !flowers) {
            return true;
        }
        ArrayList<Integer> arrayList = this.buggedStates;
        synchronized (arrayList) {
            if (this.buggedStates.contains(state)) {
                return true;
            }
        }
        MapColor materialColor = null;
        try {
            materialColor = b.func_149728_f(meta);
        }
        catch (Throwable t) {
            ArrayList<Integer> arrayList2 = this.buggedStates;
            synchronized (arrayList2) {
                this.buggedStates.add(state);
            }
            System.out.println("Broken vanilla map color definition found: " + b.func_149732_F());
        }
        return materialColor == null || materialColor.field_76291_p == 0;
    }

    public void loadPixel(World world, MapBlock pixel, MapBlock currentPixel, Chunk bchunk, int insideX, int insideZ, int highY, int lowY, boolean cave, boolean canReuseBiomeColours, boolean flowers) {
        int h;
        pixel.prepareForWriting();
        this.overlayBuilder.startBuilding();
        boolean underair = !cave;
        int opaqueState = -1;
        Block opaqueBlock = null;
        int opaqueBlockMeta = -1;
        byte workingLight = -1;
        this.mutableGlobalPos.setPos((bchunk.field_76635_g << 4) + insideX, lowY - 1, (bchunk.field_76647_h << 4) + insideZ);
        for (h = highY; h >= lowY; --h) {
            this.mutableLocalPos.setPos(insideX, h, insideZ);
            Block b = bchunk.func_150810_a(this.mutableLocalPos.getX(), this.mutableLocalPos.getY(), this.mutableLocalPos.getZ());
            if (b == null) {
                b = Blocks.field_150350_a;
            }
            int meta = bchunk.func_76628_c(this.mutableLocalPos.getX(), this.mutableLocalPos.getY(), this.mutableLocalPos.getZ());
            if (b instanceof BlockAir) {
                underair = true;
                continue;
            }
            if (!underair) continue;
            int stateId = Misc.getStateId(Block.func_149682_b((Block)b), meta);
            this.mutableGlobalPos.setPos(this.mutableGlobalPos.getX(), h, this.mutableGlobalPos.getZ());
            this.mutableLocalPos.setPos(insideX, Math.min(h + 1, 255), insideZ);
            if (this.isInvisible(world, b, meta, stateId, flowers)) continue;
            workingLight = (byte)bchunk.func_76614_a(EnumSkyBlock.Block, this.mutableLocalPos.getX(), this.mutableLocalPos.getY(), this.mutableLocalPos.getZ());
            if (this.shouldOverlay(b, b.func_149717_k())) {
                this.writerBiomeInfoSupplier.set(currentPixel, canReuseBiomeColours);
                this.overlayBuilder.build(stateId, this.biomeBuffer, b.func_149717_k(), workingLight, world, this.mapProcessor, this.mutableGlobalPos, this.overlayBuilder.getOverlayBiome(), this.colorTypeCache, this.writerBiomeInfoSupplier);
                continue;
            }
            opaqueState = stateId;
            opaqueBlock = b;
            opaqueBlockMeta = meta;
            break;
        }
        if (h < lowY) {
            h = lowY;
        }
        int stateId = opaqueState == -1 ? 0 : opaqueState;
        byte light = opaqueState == -1 ? (byte)0 : workingLight;
        Block b = opaqueState == -1 ? Blocks.field_150350_a : opaqueBlock;
        int meta = opaqueState == -1 ? 0 : opaqueBlockMeta;
        this.overlayBuilder.finishBuilding(pixel);
        if (!canReuseBiomeColours || currentPixel == null || currentPixel.getState() != stateId) {
            this.colorTypeCache.getBlockBiomeColour(world, b, meta, stateId, this.mutableGlobalPos, this.biomeBuffer, -1);
        } else {
            this.biomeBuffer[0] = currentPixel.getColourType();
            this.biomeBuffer[1] = currentPixel.getBiome();
            this.biomeBuffer[2] = currentPixel.getCustomColour();
        }
        if (this.overlayBuilder.getOverlayBiome() != -1) {
            this.biomeBuffer[1] = this.overlayBuilder.getOverlayBiome();
        }
        boolean glowing = this.isGlowing(b);
        pixel.write(stateId, h, this.biomeBuffer, light, glowing, cave);
    }

    public int loadBlockColourFromTexture(int stateId, boolean convert, BlockPos globalPos) {
        if (this.clearCachedColours) {
            this.textureColours.clear();
            this.blockColours.clear();
            this.lastBlockStateForTextureColor = -1;
            this.lastBlockStateForTextureColorResult = -1;
            this.clearCachedColours = false;
            if (WorldMap.settings.debug) {
                System.out.println("Xaero's World Map cache cleared!");
            }
        }
        if (stateId == this.lastBlockStateForTextureColor) {
            return this.lastBlockStateForTextureColorResult;
        }
        Integer c = this.blockColours.get(stateId);
        int red = 0;
        int green = 0;
        int blue = 0;
        Block b = Block.func_149729_e((int)Misc.getIdFromStateId(stateId));
        int meta = Misc.getMetaFromStateId(stateId);
        if (c == null) {
            IIcon texture = Misc.getTopIconForBlock(b, meta);
            String name = null;
            try {
                Integer cachedColour;
                if (texture == null) {
                    throw new SilentException("Null texture " + b + " " + meta);
                }
                name = texture.func_94215_i() + ".png";
                if (b instanceof BlockOre && b != Blocks.field_150449_bY) {
                    name = "minecraft:stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    MapWriter.DEFAULT_RESOURCE[1] = args[0];
                    args = DEFAULT_RESOURCE;
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/blocks/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(location);
                    if (resource == null) {
                        throw new SilentException("No texture " + location);
                    }
                    InputStream input = resource.func_110527_b();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 0;
                    int ts = Math.min(img.getWidth(), img.getHeight());
                    if (ts > 0) {
                        int diff = Math.max(1, Math.min(4, ts / 8));
                        int parts = ts / diff;
                        Raster raster = img.getData();
                        int[] colorHolder = null;
                        for (int i = 0; i < parts; ++i) {
                            for (int j = 0; j < parts; ++j) {
                                int rgb;
                                if (img.getColorModel().getNumComponents() < 3) {
                                    colorHolder = raster.getPixel(i * diff, j * diff, colorHolder);
                                    int sample = colorHolder[0] & 0xFF;
                                    int a = 255;
                                    if (colorHolder.length > 1) {
                                        a = colorHolder[1];
                                    }
                                    rgb = a << 24 | sample << 16 | sample << 8 | sample;
                                } else {
                                    rgb = img.getRGB(i * diff, j * diff);
                                }
                                int alpha = rgb >> 24 & 0xFF;
                                if (rgb == 0 || alpha == 0) continue;
                                red += rgb >> 16 & 0xFF;
                                green += rgb >> 8 & 0xFF;
                                blue += rgb & 0xFF;
                                ++total;
                            }
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new SilentException("Black texture " + ts);
                    }
                    c = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(stateId, false, globalPos);
                }
                System.out.println("Block file not found: " + b.func_149732_F());
                c = 0;
                if (b.func_149728_f(meta) != null) {
                    c = b.func_149728_f((int)meta).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
            }
            catch (Exception e) {
                System.out.println("Exception when loading " + b.func_149732_F() + " texture, using material colour.");
                c = 0;
                if (b.func_149728_f(meta) != null) {
                    c = b.func_149728_f((int)meta).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                if (e instanceof SilentException) {
                    System.out.println(e.getMessage());
                }
                e.printStackTrace();
            }
            if (c != null) {
                this.blockColours.put(stateId, c);
            }
        }
        this.lastBlockStateForTextureColor = stateId;
        this.lastBlockStateForTextureColorResult = c;
        return c;
    }

    public long getUpdateCounter() {
        return this.updateCounter;
    }

    public void resetPosition() {
        this.X = 0;
        this.Z = 0;
        this.insideX = 0;
        this.insideZ = 0;
    }

    public void requestCachedColoursClear() {
        this.clearCachedColours = true;
    }

    public BlockStateColorTypeCache getColorTypeCache() {
        return this.colorTypeCache;
    }

    public void setMapProcessor(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
    }

    public void setDirtyInWriteDistance(EntityPlayer player, World level) {
        int writeDistance = this.getWriteDistance();
        int playerChunkX = OptimizedMath.myFloor((double)player.field_70165_t) >> 4;
        int playerChunkZ = OptimizedMath.myFloor((double)player.field_70161_v) >> 4;
        int startChunkX = playerChunkX - writeDistance;
        int startChunkZ = playerChunkZ - writeDistance;
        int endChunkX = playerChunkX + writeDistance;
        int endChunkZ = playerChunkZ + writeDistance;
        for (int x = startChunkX; x < endChunkX; ++x) {
            for (int z = startChunkZ; z < endChunkZ; ++z) {
                Chunk chunk = level.func_72964_e(x, z);
                if (chunk == null) continue;
                try {
                    XaeroWorldMapCore.chunkCleanField.set(chunk, false);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

