/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.ColorizerFoliage;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraft.world.biome.BiomeGenSwamp;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import xaero.map.BlockPos;

public class MapBiomes {
    protected final NoiseGeneratorPerlin GRASS_COLOR_NOISE = new NoiseGeneratorPerlin(new Random(2345L), 1);

    public int getBiomeGrassColour(int biomeId, BiomeGenBase biome, BlockPos pos) {
        if (this.isVanilla(biomeId)) {
            if (biome instanceof BiomeGenForest) {
                return this.forestGrassColor(biomeId, biome, pos);
            }
            if (biome instanceof BiomeGenMesa) {
                return 9470285;
            }
            if (biome instanceof BiomeGenSwamp) {
                return this.swampGrassColor(pos);
            }
            return this.defaultGrassColor(biome, pos);
        }
        return biome.func_150558_b(pos.getX(), pos.getY(), pos.getZ());
    }

    public int getBiomeFoliageColour(int biomeId, BiomeGenBase biome, BlockPos pos) {
        if (this.isVanilla(biomeId)) {
            if (biome instanceof BiomeGenMesa) {
                return 10387789;
            }
            if (biome instanceof BiomeGenSwamp) {
                return 6975545;
            }
            return this.defaultFoliageColor(biome, pos);
        }
        return biome.func_150571_c(pos.getX(), pos.getY(), pos.getZ());
    }

    public int getBiomeWaterColour(int biomeId, BiomeGenBase biome) {
        if (this.isVanilla(biomeId)) {
            if (biome instanceof BiomeGenSwamp) {
                return 14745518;
            }
            return this.defaultWaterColor(biome);
        }
        return biome.getWaterColorMultiplier();
    }

    private boolean isVanilla(int biomeId) {
        return biomeId < 40;
    }

    private int defaultGrassColor(BiomeGenBase biome, BlockPos pos) {
        double d0 = MathHelper.func_76131_a((float)biome.func_150564_a(pos.getX(), pos.getY(), pos.getZ()), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        return ColorizerGrass.func_77480_a((double)d0, (double)d1);
    }

    private int forestGrassColor(int biomeId, BiomeGenBase biome, BlockPos pos) {
        int i = this.defaultGrassColor(biome, pos);
        return biome == BiomeGenBase.field_150585_R ? (i & 0xFEFEFE) + 2634762 >> 1 : i;
    }

    private int swampGrassColor(BlockPos pos) {
        double d0 = this.GRASS_COLOR_NOISE.func_151601_a((double)pos.getX() * 0.0225, (double)pos.getZ() * 0.0225);
        return d0 < -0.1 ? 5011004 : 6975545;
    }

    private int defaultFoliageColor(BiomeGenBase biome, BlockPos pos) {
        double d0 = MathHelper.func_76131_a((float)biome.func_150564_a(pos.getX(), pos.getY(), pos.getZ()), (float)0.0f, (float)1.0f);
        double d1 = MathHelper.func_76131_a((float)biome.func_76727_i(), (float)0.0f, (float)1.0f);
        return ColorizerFoliage.func_77470_a((double)d0, (double)d1);
    }

    private int defaultWaterColor(BiomeGenBase biome) {
        return 0xFFFFFF;
    }
}

