/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.biome;

import net.minecraft.block.Block;
import net.minecraft.world.World;
import xaero.map.BlockPos;
import xaero.map.biome.BiomeInfoSupplier;
import xaero.map.cache.BlockStateColorTypeCache;
import xaero.map.region.MapBlock;
import xaero.map.region.Overlay;

public class WriterBiomeInfoSupplier
implements BiomeInfoSupplier {
    private MapBlock currentPixel;
    private boolean canReuseBiomeColours;
    private BlockPos mutableGlobalPos;

    public WriterBiomeInfoSupplier(BlockPos mutableGlobalPos) {
        this.mutableGlobalPos = mutableGlobalPos;
    }

    public void set(MapBlock currentPixel, boolean canReuseBiomeColours) {
        this.currentPixel = currentPixel;
        this.canReuseBiomeColours = canReuseBiomeColours;
    }

    @Override
    public void getBiomeInfo(BlockStateColorTypeCache colorTypeCache, World world, int state, Block b, int meta, BlockPos pos, int[] biomeBuffer, int biomeId) {
        MapBlock currentPixel = this.currentPixel;
        if (this.canReuseBiomeColours && currentPixel != null && currentPixel.getNumberOfOverlays() > 0 && currentPixel.getOverlays().get(0).getState() == state) {
            Overlay currentTopOverlay = currentPixel.getOverlays().get(0);
            biomeBuffer[0] = currentTopOverlay.getColourType();
            biomeBuffer[1] = currentTopOverlay.getColourType() == 1 ? currentPixel.getBiome() : -1;
            biomeBuffer[2] = currentTopOverlay.getCustomColour();
        } else {
            colorTypeCache.getOverlayBiomeColour(world, b, meta, state, pos, biomeBuffer, biomeId);
        }
    }
}

