/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.mods.SupportMods;
import xaero.patreon.GuiUpdateAll3;
import xaero.patreon.Patreon7;

public class Events {
    private boolean listenToTextureStitch;
    private boolean skippedFirstPair;

    @SubscribeEvent
    public void guiButtonClick(GuiScreenEvent.ActionPerformedEvent event) {
    }

    @SubscribeEvent
    public void guiOpen(GuiOpenEvent event) {
        WorldMapSession worldmapSession;
        if (event.gui == null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.onGuiClosed();
        }
    }

    @SubscribeEvent
    public void modelBake(TextureStitchEvent.Post event) throws IOException {
        boolean shouldListen;
        boolean bl = shouldListen = this.listenToTextureStitch && this.skippedFirstPair;
        if (this.listenToTextureStitch) {
            this.skippedFirstPair = true;
        }
        this.listenToTextureStitch = !this.listenToTextureStitch;
        WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
        if (worldmapSession != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            mapProcessor.getMapWriter().getColorTypeCache().updateGrassColor();
            if (shouldListen) {
                mapProcessor.getMapWriter().requestCachedColoursClear();
            }
        }
        if (shouldListen) {
            if (SupportMods.minimap()) {
                WorldMap.waypointSymbolCreator.resetChars();
            }
            if (WorldMap.settings != null) {
                WorldMap.settings.updateRegionCacheHashCode();
            }
        }
    }

    @SubscribeEvent
    public void renderTick(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (Patreon7.needsNotification() && event.gui instanceof GuiMainMenu && (!SupportMods.minimap() || SupportMods.xaeroMinimap.compatibilityVersion < 1)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiUpdateAll3());
        } else if (WorldMap.isOutdated) {
            WorldMap.isOutdated = false;
        }
    }

    @SubscribeEvent
    public void worldUnload(WorldEvent.Unload event) {
        WorldMapSession worldmapSession;
        if (Minecraft.func_71410_x().field_71439_g != null && (worldmapSession = WorldMapSession.getCurrentSession()) != null) {
            MapProcessor mapProcessor = worldmapSession.getMapProcessor();
            if (event.world == mapProcessor.mainWorld) {
                mapProcessor.onWorldUnload();
            }
        }
        if (event.world instanceof WorldServer) {
            WorldServer sw = (WorldServer)event.world;
            WorldMapSession worldmapSession2 = WorldMapSession.getCurrentSession();
            if (worldmapSession2 != null) {
                MapProcessor mapProcessor = worldmapSession2.getMapProcessor();
                mapProcessor.getWorldDataHandler().onServerWorldUnload(sw);
            }
        }
    }

    @SubscribeEvent
    public void renderOverlayPre(RenderGameOverlayEvent.Pre event) {
        if (event.type == RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            String crosshairMessage;
            WorldMapSession worldmapSession = WorldMapSession.getCurrentSession();
            MapProcessor mapProcessor = worldmapSession == null ? null : worldmapSession.getMapProcessor();
            String string = crosshairMessage = mapProcessor == null ? null : mapProcessor.getCrosshairMessage();
            if (crosshairMessage != null) {
                int messageWidth = Minecraft.func_71410_x().field_71466_p.func_78256_a(crosshairMessage);
                GL11.glDisable((int)3042);
                Minecraft.func_71410_x().field_71466_p.func_78261_a(crosshairMessage, event.resolution.func_78326_a() / 2 - messageWidth / 2, event.resolution.func_78328_b() / 2 + 60, -1);
                GL11.glEnable((int)3042);
            }
        }
    }
}

