/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.file.worldsave;

import java.io.File;
import java.io.IOException;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import xaero.map.MapProcessor;
import xaero.map.file.worldsave.WorldDataReader;
import xaero.map.region.MapRegion;

public class WorldDataHandler {
    private WorldDataReader worldDataReader;
    private WorldServer worldServer;
    private File worldDir;

    public WorldDataHandler(WorldDataReader worldDataReader) {
        this.worldDataReader = worldDataReader;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void prepareSingleplayer(World world, MapProcessor mapProcessor) {
        String worldId = mapProcessor.getCurrentWorldId();
        if (world != null) {
            if (!MapProcessor.isWorldMultiplayer(MapProcessor.isWorldRealms(worldId), worldId)) {
                this.worldServer = DimensionManager.getWorld((int)world.field_73011_w.field_76574_g);
                if (this.worldServer != null) {
                    this.worldDir = this.worldServer.getChunkSaveLocation();
                    return;
                }
                this.worldDir = null;
                return;
            }
        }
        this.worldDir = null;
    }

    public Result buildRegion(MapRegion region, World world, boolean loading, int[] chunkCountDest) throws IOException {
        if (this.worldServer == null) {
            System.out.println("Tried loading a region for a null server world!");
            return Result.CANCEL;
        }
        boolean buildResult = this.worldDataReader.buildRegion(region, this.worldDir, world, loading, chunkCountDest);
        return buildResult ? Result.SUCCESS : Result.FAIL;
    }

    public void onServerWorldUnload(WorldServer sw) {
        if (sw == this.worldServer) {
            this.worldServer = null;
        }
    }

    public WorldServer getWorldServer() {
        return this.worldServer;
    }

    public WorldDataReader getWorldDataReader() {
        return this.worldDataReader;
    }

    public File getWorldDir() {
        return this.worldDir;
    }

    public static enum Result {
        SUCCESS,
        FAIL,
        CANCEL;

    }
}

