/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.graphics;

import java.nio.ByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.Util;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.PixelBuffers;
import xaero.map.pool.PoolUnit;
import xaero.map.region.texture.BranchTextureRenderer;

public abstract class TextureUpload
implements PoolUnit {
    protected int glTexture;
    private int glUnpackPbo;
    private int target;
    private int level;
    private int internalFormat;
    private int width;
    private int height;
    private int border;
    private long pixels_buffer_offset;
    private int uploadType;

    @Override
    public void create(Object ... args) {
        this.glTexture = (Integer)args[0];
        this.glUnpackPbo = (Integer)args[1];
        this.target = (Integer)args[2];
        this.level = (Integer)args[3];
        this.internalFormat = (Integer)args[4];
        this.width = (Integer)args[5];
        this.height = (Integer)args[6];
        this.border = (Integer)args[7];
        this.pixels_buffer_offset = (Long)args[8];
    }

    public void run() {
        GL11.glBindTexture((int)3553, (int)this.glTexture);
        OpenGLException.checkGLError(false, "preparing to upload a map texture");
        PixelBuffers.glBindBuffer(35052, this.glUnpackPbo);
        Util.checkGLError();
        this.upload();
        Util.checkGLError();
        PixelBuffers.glBindBuffer(35052, 0);
        GL11.glBindTexture((int)3553, (int)0);
        Util.checkGLError();
    }

    abstract void upload();

    public int getUploadType() {
        return this.uploadType;
    }

    public static class BranchDownload
    extends TextureUpload {
        private int glPackPbo;
        private int pboOffset;

        public BranchDownload(int uploadType) {
            ((TextureUpload)this).uploadType = uploadType;
        }

        public BranchDownload(Object ... args) {
            this(5);
            this.create(args);
        }

        @Override
        void upload() throws OpenGLException {
            if (this.glPackPbo == 0) {
                return;
            }
            PixelBuffers.glBindBuffer(35051, this.glPackPbo);
            int target = ((TextureUpload)this).target;
            GL11.glGetTexImage((int)target, (int)0, (int)32993, (int)32821, (long)this.pboOffset);
            PixelBuffers.glBindBuffer(35051, 0);
            OpenGLException.checkGLError();
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.glPackPbo = (Integer)args[9];
            this.pboOffset = (Integer)args[10];
        }
    }

    public static class BranchUpdate
    extends TextureUpload {
        private int format;
        private int type;
        private boolean allocate;
        private Integer srcTextureTopLeft;
        private Integer srcTextureTopRight;
        private Integer srcTextureBottomLeft;
        private Integer srcTextureBottomRight;
        private BranchTextureRenderer renderer;
        private int glPackPbo;
        private int pboOffset;
        private ScaledResolution scaledRes;

        public BranchUpdate(int uploadType) {
            ((TextureUpload)this).uploadType = uploadType;
        }

        public BranchUpdate(Object ... args) {
            this((Boolean)args[11] != false ? 4 : 3);
            this.create(args);
        }

        @Override
        void upload() throws OpenGLException {
            if (this.allocate) {
                GL11.glTexImage2D((int)((TextureUpload)this).target, (int)((TextureUpload)this).level, (int)((TextureUpload)this).internalFormat, (int)((TextureUpload)this).width, (int)((TextureUpload)this).height, (int)0, (int)this.format, (int)this.type, (ByteBuffer)null);
                OpenGLException.checkGLError();
            }
            this.renderer.render(this.glTexture, this.srcTextureTopLeft, this.srcTextureTopRight, this.srcTextureBottomLeft, this.srcTextureBottomRight, Minecraft.func_71410_x().func_147110_a(), this.allocate, this.scaledRes);
            GL11.glBindTexture((int)3553, (int)this.glTexture);
            PixelBuffers.glBindBuffer(35051, this.glPackPbo);
            if (this.glPackPbo == 0) {
                return;
            }
            int target = ((TextureUpload)this).target;
            GL11.glGetTexImage((int)target, (int)0, (int)32993, (int)32821, (long)this.pboOffset);
            PixelBuffers.glBindBuffer(35051, 0);
            OpenGLException.checkGLError();
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.format = (Integer)args[9];
            this.type = (Integer)args[10];
            this.allocate = (Boolean)args[11];
            this.srcTextureTopLeft = (Integer)args[12];
            this.srcTextureTopRight = (Integer)args[13];
            this.srcTextureBottomLeft = (Integer)args[14];
            this.srcTextureBottomRight = (Integer)args[15];
            this.renderer = (BranchTextureRenderer)args[16];
            this.glPackPbo = (Integer)args[17];
            this.pboOffset = (Integer)args[18];
            this.scaledRes = (ScaledResolution)args[19];
        }
    }

    public static class Compressed
    extends TextureUpload {
        private int dataSize;

        public Compressed(Object ... args) {
            this.create(args);
            ((TextureUpload)this).uploadType = 2;
        }

        @Override
        void upload() {
            GL13.glCompressedTexImage2D((int)((TextureUpload)this).target, (int)((TextureUpload)this).level, (int)((TextureUpload)this).internalFormat, (int)((TextureUpload)this).width, (int)((TextureUpload)this).height, (int)((TextureUpload)this).border, (int)this.dataSize, (long)((TextureUpload)this).pixels_buffer_offset);
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.dataSize = (Integer)args[9];
        }
    }

    public static class NormalWithDownload
    extends Normal {
        private int glPackPbo;

        public NormalWithDownload(Object ... args) {
            super(1);
            this.create(args);
        }

        @Override
        void upload() {
            super.upload();
            PixelBuffers.glBindBuffer(35051, this.glPackPbo);
            int target = ((TextureUpload)this).target;
            int isCompressed = GL11.glGetTexLevelParameteri((int)target, (int)0, (int)34465);
            if (isCompressed == 1) {
                GL13.glGetCompressedTexImage((int)target, (int)0, (long)0L);
            } else {
                GL11.glGetTexImage((int)target, (int)0, (int)32993, (int)32821, (long)0L);
            }
            PixelBuffers.glBindBuffer(35051, 0);
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.glPackPbo = (Integer)args[11];
        }
    }

    public static class Normal
    extends TextureUpload {
        private int format;
        private int type;

        public Normal(int uploadType) {
            ((TextureUpload)this).uploadType = uploadType;
        }

        public Normal(Object ... args) {
            this(0);
            this.create(args);
        }

        @Override
        void upload() {
            GL11.glHint((int)34031, (int)4354);
            OpenGLException.checkGLError();
            GL11.glTexImage2D((int)((TextureUpload)this).target, (int)((TextureUpload)this).level, (int)((TextureUpload)this).internalFormat, (int)((TextureUpload)this).width, (int)((TextureUpload)this).height, (int)((TextureUpload)this).border, (int)this.format, (int)this.type, (long)((TextureUpload)this).pixels_buffer_offset);
            OpenGLException.checkGLError(false, "uploading a map texture");
        }

        @Override
        public void create(Object ... args) {
            super.create(args);
            this.format = (Integer)args[9];
            this.type = (Integer)args[10];
        }
    }
}

