/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import xaero.map.MapProcessor;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiMapName;
import xaero.map.gui.GuiMapSwitchingButton;
import xaero.map.gui.IDropDownCallback;
import xaero.map.gui.TooltipButton;
import xaero.map.gui.YesNoCallbackImplementation;
import xaero.map.misc.KeySortableByOther;
import xaero.map.world.MapDimension;
import xaero.map.world.MapWorld;

public class GuiMapSwitching {
    private MapProcessor mapProcessor;
    private MapDimension settingsDimension;
    private String[] mwDropdownValues;
    private GuiButton switchingButton;
    private GuiButton multiworldTypeOptionButton;
    private GuiButton renameButton;
    private GuiButton deleteButton;
    private CursorBox serverSelectionModeBox = new CursorBox("gui.xaero_mw_server_box");
    private CursorBox mapSelectionBox = new CursorBox("gui.xaero_map_selection_box");
    public boolean active;
    private boolean writableOnInit;

    public GuiMapSwitching(MapProcessor mapProcessor) {
        this.mapProcessor = mapProcessor;
        this.mapSelectionBox.setBoxWidth(200);
        this.serverSelectionModeBox.setBoxWidth(200);
    }

    public void init(final GuiMap mapScreen, List<GuiDropDown> dropdowns, final Minecraft minecraft, int width, int height) {
        this.multiworldTypeOptionButton = null;
        MapWorld mapWorld = this.mapProcessor.getMapWorld();
        MapDimension mapDimension = this.settingsDimension = mapWorld == null || mapWorld.getCurrentDimensionId() == null ? null : mapWorld.getCurrentDimension();
        if (this.settingsDimension != null && mapWorld.isMultiplayer()) {
            this.writableOnInit = this.settingsDimension.futureMultiworldWritable;
            this.switchingButton = new GuiMapSwitchingButton(this.active, 0, height - 20);
            mapScreen.addGuiButton(this.switchingButton);
            if (this.active) {
                String currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced();
                ArrayList<KeySortableByOther<String>> sortableList = new ArrayList<KeySortableByOther<String>>();
                for (String string : this.settingsDimension.getMultiworldIdsCopy()) {
                    sortableList.add(new KeySortableByOther<String>(string, new Comparable[]{this.settingsDimension.getMultiworldName(string).toLowerCase()}));
                }
                Collections.sort(sortableList);
                ArrayList<String> dropdownValuesList = new ArrayList<String>();
                for (KeySortableByOther keySortableByOther : sortableList) {
                    dropdownValuesList.add((String)keySortableByOther.getKey());
                }
                int n = this.getDropdownSelectionIdFromValue(dropdownValuesList, currentMultiworld);
                if (n == dropdownValuesList.size()) {
                    dropdownValuesList.add(currentMultiworld);
                }
                this.mwDropdownValues = dropdownValuesList.toArray(new String[0]);
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String s : dropdownValuesList) {
                    arrayList.add(this.settingsDimension.getMultiworldName(s));
                }
                if (this.settingsDimension.getMapWorld().isMultiplayer()) {
                    arrayList.add("\u00a78" + I18n.func_135052_a((String)"gui.xaero_create_new_map", (Object[])new Object[0]));
                }
                GuiDropDown createdDropdown = new GuiDropDown(arrayList.toArray(new String[0]), width / 2 - 100, 30, 200, n, new IDropDownCallback(){

                    @Override
                    public boolean onSelected(GuiDropDown dd, int i) {
                        if (i < GuiMapSwitching.this.mwDropdownValues.length) {
                            GuiMapSwitching.this.mapProcessor.setMultiworld(GuiMapSwitching.this.settingsDimension, GuiMapSwitching.this.mwDropdownValues[i]);
                            GuiMapSwitching.this.updateButtons();
                            return true;
                        }
                        minecraft.func_147108_a((GuiScreen)new GuiMapName(GuiMapSwitching.this.mapProcessor, mapScreen, mapScreen, GuiMapSwitching.this.settingsDimension, null));
                        return false;
                    }
                });
                dropdowns.add(createdDropdown);
                this.multiworldTypeOptionButton = new TooltipButton(0, height - 45, 150, 20, this.getMultiworldTypeButtonMessage(), this.settingsDimension.isFutureMultiworldServerBased() ? this.serverSelectionModeBox : this.mapSelectionBox);
                mapScreen.addGuiButton(this.multiworldTypeOptionButton);
                this.renameButton = new GuiButton(-1, width / 2 + 109, 26, 60, 20, I18n.func_135052_a((String)"gui.xaero_rename", (Object[])new Object[0]));
                mapScreen.addGuiButton(this.renameButton);
                this.deleteButton = new GuiButton(-1, width / 2 - 168, 26, 60, 20, I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0]));
                mapScreen.addGuiButton(this.deleteButton);
                this.updateButtons();
                this.multiworldTypeOptionButton.field_146124_l = this.isMapSelectionOptionEnabled();
                this.renameButton.field_146124_l = this.settingsDimension.getMapWorld().isMultiplayer();
                mapScreen.addGuiButton(new GuiButton(200, width / 2 - 50, 50, 100, 20, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
            }
        }
    }

    private boolean isMapSelectionOptionEnabled() {
        return !this.settingsDimension.isFutureMultiworldServerBased() && this.settingsDimension.getMapWorld().isMultiplayer();
    }

    private void updateButtons() {
        this.switchingButton.field_146124_l = this.settingsDimension != null && this.settingsDimension.futureMultiworldWritable;
        this.deleteButton.field_146124_l = this.settingsDimension.getMapWorld().isMultiplayer() && this.mwDropdownValues.length > 1 && this.settingsDimension.getFutureCustomSelectedMultiworld() != null;
    }

    private String getMultiworldTypeButtonMessage() {
        int multiworldType = this.settingsDimension.getMapWorld().getFutureMultiworldType(this.settingsDimension);
        return I18n.func_135052_a((String)"gui.xaero_map_selection", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)(this.settingsDimension.isFutureMultiworldServerBased() ? "gui.xaero_mw_server" : (multiworldType == 0 ? "gui.xaero_mw_single" : (multiworldType == 1 ? "gui.xaero_mw_manual" : "gui.xaero_mw_spawn"))), (Object[])new Object[0]);
    }

    public void confirm(GuiMap mapScreen, Minecraft minecraft, int width, int height) {
        if (this.mapProcessor.confirmMultiworld(this.settingsDimension)) {
            this.active = false;
            mapScreen.func_146280_a(minecraft, width, height);
        }
    }

    private int getDropdownSelectionIdFromValue(List<String> values, String value) {
        int selected = 0;
        for (selected = 0; selected < values.size() && !values.get(selected).equals(value); ++selected) {
        }
        return selected;
    }

    public void preMapRender(GuiMap mapScreen, List<GuiDropDown> dropdowns, Minecraft minecraft, int width, int height) {
        String currentDropdownSelection;
        String currentMultiworld;
        MapDimension currentDim;
        MapDimension mapDimension = currentDim = !this.mapProcessor.isMapWorldUsable() ? null : this.mapProcessor.getMapWorld().getCurrentDimension();
        if (currentDim != this.settingsDimension) {
            this.active = false;
            mapScreen.func_146280_a(minecraft, width, height);
        }
        if (!this.active && this.settingsDimension != null && !this.settingsDimension.futureMultiworldWritable) {
            this.active = true;
            mapScreen.func_146280_a(minecraft, width, height);
        }
        if (this.active && this.settingsDimension != null && dropdowns.get(0).isClosed() && (!(currentMultiworld = this.settingsDimension.getFutureMultiworldUnsynced()).equals(currentDropdownSelection = this.mwDropdownValues[dropdowns.get(0).getSelected()]) || this.writableOnInit != this.settingsDimension.futureMultiworldWritable)) {
            mapScreen.func_146280_a(minecraft, width, height);
        }
    }

    public void renderText(Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
        if (!this.active) {
            return;
        }
        String selectMapString = I18n.func_135052_a((String)"gui.xaero_select_map", (Object[])new Object[0]) + ":";
        minecraft.field_71466_p.func_78261_a(selectMapString, width / 2 - minecraft.field_71466_p.func_78256_a(selectMapString) / 2, 19, -1);
    }

    public void postMapRender(Minecraft minecraft, int mouseX, int mouseY, int width, int height) {
    }

    public void actionPerformed(final GuiMap mapScreen, final Minecraft minecraft, final int width, final int height, GuiButton b) {
        if (b.field_146124_l) {
            if (b == this.switchingButton) {
                this.active = !this.active;
                mapScreen.func_146280_a(minecraft, width, height);
            } else if (b == this.multiworldTypeOptionButton) {
                if (this.isMapSelectionOptionEnabled()) {
                    this.mapProcessor.toggleMultiworldType(this.settingsDimension);
                    b.field_146126_j = this.getMultiworldTypeButtonMessage();
                }
            } else if (b == this.renameButton) {
                minecraft.func_147108_a((GuiScreen)new GuiMapName(this.mapProcessor, mapScreen, mapScreen, this.settingsDimension, this.settingsDimension.getFutureMultiworldUnsynced()));
            } else if (b == this.deleteButton) {
                if (this.settingsDimension.getFutureCustomSelectedMultiworld() != null) {
                    final String selectedMWId = this.settingsDimension.getFutureCustomSelectedMultiworld();
                    minecraft.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)new YesNoCallbackImplementation(){

                        @Override
                        public void func_73878_a(boolean result, int id) {
                            if (result) {
                                String mapNameAndIdLine = I18n.func_135052_a((String)"gui.xaero_delete_map_msg4", (Object[])new Object[0]) + ": " + GuiMapSwitching.this.settingsDimension.getMultiworldName(selectedMWId) + " (" + selectedMWId + ")";
                                minecraft.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)new YesNoCallbackImplementation(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    @Override
                                    public void func_73878_a(boolean result2, int id) {
                                        if (result2) {
                                            Object object = ((GuiMapSwitching)GuiMapSwitching.this).mapProcessor.uiSync;
                                            synchronized (object) {
                                                if (GuiMapSwitching.this.mapProcessor.getMapWorld() == GuiMapSwitching.this.settingsDimension.getMapWorld()) {
                                                    MapDimension currentDimension;
                                                    MapDimension mapDimension = currentDimension = !GuiMapSwitching.this.mapProcessor.isMapWorldUsable() ? null : GuiMapSwitching.this.mapProcessor.getMapWorld().getCurrentDimension();
                                                    if (GuiMapSwitching.this.settingsDimension == currentDimension && GuiMapSwitching.this.settingsDimension.getCurrentMultiworld().equals(selectedMWId)) {
                                                        if (WorldMap.settings.debug) {
                                                            System.out.println("Delayed map deletion!");
                                                        }
                                                        GuiMapSwitching.this.mapProcessor.requestCurrentMapDeletion();
                                                    } else {
                                                        if (WorldMap.settings.debug) {
                                                            System.out.println("Instant map deletion!");
                                                        }
                                                        GuiMapSwitching.this.settingsDimension.deleteMultiworldMapDataUnsynced(selectedMWId);
                                                    }
                                                    GuiMapSwitching.this.settingsDimension.deleteMultiworldId(selectedMWId);
                                                    GuiMapSwitching.this.settingsDimension.pickDefaultCustomMultiworldUnsynced();
                                                    GuiMapSwitching.this.settingsDimension.saveConfigUnsynced();
                                                    ((GuiMapSwitching)GuiMapSwitching.this).settingsDimension.futureMultiworldWritable = false;
                                                    mapScreen.func_146280_a(minecraft, width, height);
                                                }
                                            }
                                        }
                                        minecraft.func_147108_a((GuiScreen)mapScreen);
                                    }
                                }, I18n.func_135052_a((String)"gui.xaero_delete_map_msg3", (Object[])new Object[0]), mapNameAndIdLine, -1));
                            } else {
                                minecraft.func_147108_a((GuiScreen)mapScreen);
                            }
                        }
                    }, I18n.func_135052_a((String)"gui.xaero_delete_map_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_delete_map_msg2", (Object[])new Object[0]), -1));
                }
            } else if (b.field_146127_k == 200) {
                this.confirm(mapScreen, minecraft, width, height);
            }
        }
    }
}

