/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.nio.IntBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import xaero.map.WorldMap;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.misc.Misc;

public class WaypointSymbolCreator {
    public static final ResourceLocation minimapTextures = new ResourceLocation("xaerobetterpvp", "gui/guis.png");
    public static final int white = -1;
    private Minecraft mc = Minecraft.func_71410_x();
    private int deathSymbolTexture;
    private Map<String, Integer> charSymbols = new HashMap<String, Integer>();
    private ImprovedFramebuffer symbolFramebuffer32;
    private ImprovedFramebuffer symbolFramebuffer64;

    public int getDeathSymbolTexture(ScaledResolution scaledRes) {
        if (this.deathSymbolTexture == 0) {
            this.createDeathSymbolTexture(scaledRes);
        }
        return this.deathSymbolTexture;
    }

    private void createDeathSymbolTexture(ScaledResolution scaledRes) {
        this.deathSymbolTexture = this.createCharSymbol(true, null, scaledRes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getSymbolTexture(String c, ScaledResolution scaledRes) {
        Integer textureId;
        Map<String, Integer> map = this.charSymbols;
        synchronized (map) {
            textureId = this.charSymbols.get(c);
        }
        if (textureId == null) {
            textureId = this.createCharSymbol(false, c, scaledRes);
        }
        return textureId;
    }

    private int createCharSymbol(boolean death, String c, ScaledResolution scaledRes) {
        if (this.symbolFramebuffer32 == null) {
            this.symbolFramebuffer32 = new ImprovedFramebuffer(32, 32, false);
        }
        if (this.symbolFramebuffer64 == null) {
            this.symbolFramebuffer64 = new ImprovedFramebuffer(64, 32, false);
        }
        int frameWidth = 32;
        if (this.mc.field_71466_p.func_78256_a(c) / 2 > 4) {
            frameWidth = 64;
        }
        ImprovedFramebuffer symbolFramebuffer = frameWidth == 32 ? this.symbolFramebuffer32 : this.symbolFramebuffer64;
        int textureId = GL11.glGenTextures();
        GL11.glBindTexture((int)3553, (int)textureId);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glTexParameterf((int)3553, (int)33082, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)33083, (float)0.0f);
        GL11.glTexParameterf((int)3553, (int)34049, (float)0.0f);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
        GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)frameWidth, (int)32, (int)0, (int)6408, (int)5121, (IntBuffer)null);
        symbolFramebuffer.func_147610_a(true);
        symbolFramebuffer.field_147617_g = textureId;
        ImprovedFramebuffer.framebufferTexture2D(symbolFramebuffer.getType(), 36160, 36064, 3553, textureId, 0);
        symbolFramebuffer.func_147606_d();
        symbolFramebuffer.func_147610_a(true);
        GL11.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glClear((int)16384);
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)frameWidth, (double)32.0, (double)0.0, (double)-1.0, (double)1000.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glTranslatef((float)1.0f, (float)1.0f, (float)0.0f);
        if (!death) {
            GL11.glScalef((float)3.0f, (float)3.0f, (float)1.0f);
            this.mc.field_71466_p.func_78261_a(c, 0, 0, -1);
        } else {
            GL11.glScalef((float)3.0f, (float)3.0f, (float)1.0f);
            GL11.glEnable((int)3008);
            this.mc.func_110434_K().func_110577_a(minimapTextures);
            GL11.glColor4f((float)0.2431f, (float)0.2431f, (float)0.2431f, (float)1.0f);
            Gui.func_146110_a((int)1, (int)1, (float)0.0f, (float)78.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
            GL11.glColor4f((float)0.9882f, (float)0.9882f, (float)0.9882f, (float)1.0f);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)78.0f, (int)9, (int)9, (float)256.0f, (float)256.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        GL11.glMatrixMode((int)5889);
        Misc.minecraftOrtho(scaledRes);
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        symbolFramebuffer.func_147609_e();
        this.mc.func_147110_a().func_147610_a(false);
        GL11.glViewport((int)0, (int)0, (int)this.mc.field_71443_c, (int)this.mc.field_71440_d);
        if (death) {
            this.deathSymbolTexture = textureId;
        } else {
            this.charSymbols.put(c, textureId);
        }
        return textureId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetChars() {
        Map<String, Integer> map = this.charSymbols;
        synchronized (map) {
            Collection<Integer> valueSet = this.charSymbols.values();
            for (Integer textureId : valueSet) {
                WorldMap.glObjectDeleter.requestTextureDeletion(textureId);
            }
            this.charSymbols.clear();
        }
    }
}

