/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.ResourcePackRepository;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.settings.ModOptions;

public class ModSettings {
    public static int ignoreUpdate;
    public static final String format = "\u00a7";
    public static boolean updateNotification;
    private int regionCacheHashCode;
    public boolean debug = false;
    public boolean detailed_debug = false;
    public boolean lighting = true;
    public boolean loadChunks = true;
    public boolean updateChunks = true;
    public int terrainSlopes = 2;
    public String[] slopeNames = new String[]{"gui.xaero_off", "gui.xaero_wm_slopes_legacy", "gui.xaero_wm_slopes_default_3d", "gui.xaero_wm_slopes_default_2d"};
    public boolean terrainDepth = true;
    public boolean footsteps = true;
    public boolean flowers = true;
    public boolean compression = false;
    public boolean coordinates = true;
    public int colours = 0;
    public String[] colourNames = new String[]{"gui.xaero_accurate", "gui.xaero_vanilla"};
    public boolean biomeColorsVanillaMode = false;
    public boolean differentiateByServerAddress = true;
    public boolean waypoints = true;
    public boolean renderArrow = true;
    public boolean displayZoom = true;
    public boolean ignoreHeightmaps = false;
    public boolean openMapAnimation = true;
    public float worldmapWaypointsScale = 1.0f;
    public int reloadVersion = 0;
    public boolean reloadEverything = false;
    public boolean zoomButtons = true;
    public boolean waypointBackgrounds = true;
    public boolean pauseRequests = false;
    public boolean extraDebug = false;
    public boolean showDisabledWaypoints;

    public void saveSettings() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(WorldMap.optionsFile));
        writer.println("ignoreUpdate:" + ignoreUpdate);
        writer.println("updateNotification:" + updateNotification);
        writer.println("differentiateByServerAddress:" + this.differentiateByServerAddress);
        writer.println("debug:" + this.debug);
        writer.println("lighting:" + this.lighting);
        writer.println("colours:" + this.colours);
        writer.println("loadChunks:" + this.loadChunks);
        writer.println("updateChunks:" + this.updateChunks);
        writer.println("terrainSlopes:" + this.terrainSlopes);
        writer.println("terrainDepth:" + this.terrainDepth);
        writer.println("footsteps:" + this.footsteps);
        writer.println("flowers:" + this.flowers);
        writer.println("compression:" + this.compression);
        writer.println("coordinates:" + this.coordinates);
        writer.println("biomeColorsVanillaMode:" + this.biomeColorsVanillaMode);
        writer.println("waypoints:" + this.waypoints);
        writer.println("renderArrow:" + this.renderArrow);
        writer.println("displayZoom:" + this.displayZoom);
        writer.println("ignoreHeightmaps:" + this.ignoreHeightmaps);
        writer.println("worldmapWaypointsScale:" + this.worldmapWaypointsScale);
        writer.println("openMapAnimation:" + this.openMapAnimation);
        writer.println("reloadVersion:" + this.reloadVersion);
        writer.println("reloadEverything:" + this.reloadEverything);
        writer.println("zoomButtons:" + this.zoomButtons);
        writer.println("waypointBackgrounds:" + this.waypointBackgrounds);
        writer.println("showDisabledWaypoints:" + this.showDisabledWaypoints);
        writer.println("globalVersion:" + WorldMap.globalVersion);
        writer.close();
    }

    private void loadDefaultSettings() throws IOException {
        File mainConfigFile = WorldMap.optionsFile;
        File defaultConfigFile = mainConfigFile.toPath().getParent().resolveSibling("defaultconfigs").resolve(mainConfigFile.getName()).toFile();
        if (defaultConfigFile.exists()) {
            this.loadSettingsFile(defaultConfigFile);
        }
    }

    public void loadSettings() throws IOException {
        this.loadDefaultSettings();
        File mainConfigFile = WorldMap.optionsFile;
        Path configFolderPath = mainConfigFile.toPath().getParent();
        if (!Files.exists(configFolderPath, new LinkOption[0])) {
            Files.createDirectories(configFolderPath, new FileAttribute[0]);
        }
        if (!mainConfigFile.exists()) {
            this.saveSettings();
            return;
        }
        this.loadSettingsFile(WorldMap.optionsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettingsFile(File file) throws IOException {
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(file));
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                try {
                    if (args[0].equalsIgnoreCase("ignoreUpdate")) {
                        ignoreUpdate = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("updateNotification")) {
                        updateNotification = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("differentiateByServerAddress")) {
                        this.differentiateByServerAddress = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("debug")) {
                        this.debug = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("lighting")) {
                        this.lighting = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("colours")) {
                        this.colours = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("loadChunks")) {
                        this.loadChunks = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("updateChunks")) {
                        this.updateChunks = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("terrainSlopes")) {
                        this.terrainSlopes = args[1].equals("true") ? 2 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("terrainDepth")) {
                        this.terrainDepth = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("footsteps")) {
                        this.footsteps = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("flowers")) {
                        this.flowers = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("compression")) {
                        this.compression = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("coordinates")) {
                        this.coordinates = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("biomeColorsVanillaMode")) {
                        this.biomeColorsVanillaMode = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("waypoints")) {
                        this.waypoints = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("renderArrow")) {
                        this.renderArrow = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("displayZoom")) {
                        this.displayZoom = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("ignoreHeightmaps")) {
                        this.ignoreHeightmaps = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("worldmapWaypointsScale")) {
                        this.worldmapWaypointsScale = Float.parseFloat(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("openMapAnimation")) {
                        this.openMapAnimation = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("reloadVersion")) {
                        this.reloadVersion = Integer.parseInt(args[1]);
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("reloadEverything")) {
                        this.reloadEverything = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("zoomButtons")) {
                        this.zoomButtons = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("waypointBackgrounds")) {
                        this.waypointBackgrounds = args[1].equals("true");
                        continue;
                    }
                    if (args[0].equalsIgnoreCase("showDisabledWaypoints")) {
                        this.showDisabledWaypoints = args[1].equals("true");
                        continue;
                    }
                    if (!args[0].equalsIgnoreCase("globalVersion")) continue;
                    WorldMap.globalVersion = Integer.parseInt(args[1]);
                }
                catch (Exception e) {
                    System.out.println("Skipping setting:" + args[0]);
                }
            }
        }
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        String s = par1EnumOptions.getEnumString() + ": ";
        if (par1EnumOptions.getEnumFloat()) {
            float f1 = this.getOptionFloatValue(par1EnumOptions);
            return s + f1;
        }
        if (par1EnumOptions == ModOptions.COLOURS) {
            s = s + I18n.func_135052_a((String)this.colourNames[this.colours], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.SLOPES) {
            s = s + I18n.func_135052_a((String)this.slopeNames[this.terrainSlopes], (Object[])new Object[0]);
        } else {
            boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
            s = s + ModSettings.getTranslation(clientSetting);
        }
        return s;
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o == ModOptions.DEBUG) {
            return this.debug;
        }
        if (o == ModOptions.LIGHTING) {
            return this.lighting;
        }
        if (o == ModOptions.LOAD) {
            return this.loadChunks;
        }
        if (o == ModOptions.UPDATE) {
            return this.updateChunks;
        }
        if (o == ModOptions.DEPTH) {
            return this.terrainDepth;
        }
        if (o == ModOptions.STEPS) {
            return this.footsteps;
        }
        if (o == ModOptions.FLOWERS) {
            return this.flowers;
        }
        if (o == ModOptions.COMPRESSION) {
            return this.compression;
        }
        if (o == ModOptions.COORDINATES) {
            return this.coordinates;
        }
        if (o == ModOptions.BIOMES) {
            return this.biomeColorsVanillaMode;
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.waypoints;
        }
        if (o == ModOptions.ARROW) {
            return this.renderArrow;
        }
        if (o == ModOptions.DISPLAY_ZOOM) {
            return this.displayZoom;
        }
        if (o == ModOptions.IGNORE_HEIGHTMAPS) {
            return this.ignoreHeightmaps;
        }
        if (o == ModOptions.OPEN_ANIMATION) {
            return this.openMapAnimation;
        }
        if (o == ModOptions.RELOAD) {
            return this.reloadEverything;
        }
        if (o == ModOptions.ZOOM_BUTTONS) {
            return this.zoomButtons;
        }
        if (o == ModOptions.WAYPOINT_BACKGROUNDS) {
            return this.waypointBackgrounds;
        }
        if (o == ModOptions.PAUSE_REQUESTS) {
            return this.pauseRequests;
        }
        if (o == ModOptions.EXTRA_DEBUG) {
            return this.extraDebug;
        }
        if (o == ModOptions.UPDATE_NOTIFICATION) {
            return updateNotification;
        }
        return false;
    }

    private static String getTranslation(boolean o) {
        return I18n.func_135052_a((String)("gui.xaero_" + (o ? "on" : "off")), (Object[])new Object[0]);
    }

    public void setOptionValue(ModOptions par1EnumOptions, int par2) throws IOException {
        if (par1EnumOptions == ModOptions.DEBUG) {
            boolean bl = this.debug = !this.debug;
        }
        if (par1EnumOptions == ModOptions.COLOURS) {
            this.colours = (this.colours + 1) % 2;
        }
        if (par1EnumOptions == ModOptions.LIGHTING) {
            boolean bl = this.lighting = !this.lighting;
        }
        if (par1EnumOptions == ModOptions.LOAD) {
            boolean bl = this.loadChunks = !this.loadChunks;
        }
        if (par1EnumOptions == ModOptions.UPDATE) {
            boolean bl = this.updateChunks = !this.updateChunks;
        }
        if (par1EnumOptions == ModOptions.DEPTH) {
            boolean bl = this.terrainDepth = !this.terrainDepth;
        }
        if (par1EnumOptions == ModOptions.SLOPES) {
            this.terrainSlopes = (this.terrainSlopes + 1) % 4;
        }
        if (par1EnumOptions == ModOptions.STEPS) {
            boolean bl = this.footsteps = !this.footsteps;
        }
        if (par1EnumOptions == ModOptions.FLOWERS) {
            WorldMapSession session;
            this.flowers = !this.flowers;
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e != null && mc.field_71439_g != null && (session = WorldMapSession.getCurrentSession()) != null) {
                session.getMapProcessor().getMapWriter().setDirtyInWriteDistance((EntityPlayer)mc.field_71439_g, (World)mc.field_71441_e);
            }
        }
        if (par1EnumOptions == ModOptions.COMPRESSION) {
            boolean bl = this.compression = !this.compression;
        }
        if (par1EnumOptions == ModOptions.COORDINATES) {
            boolean bl = this.coordinates = !this.coordinates;
        }
        if (par1EnumOptions == ModOptions.BIOMES) {
            boolean bl = this.biomeColorsVanillaMode = !this.biomeColorsVanillaMode;
        }
        if (par1EnumOptions == ModOptions.WAYPOINTS) {
            boolean bl = this.waypoints = !this.waypoints;
        }
        if (par1EnumOptions == ModOptions.ARROW) {
            boolean bl = this.renderArrow = !this.renderArrow;
        }
        if (par1EnumOptions == ModOptions.DISPLAY_ZOOM) {
            boolean bl = this.displayZoom = !this.displayZoom;
        }
        if (par1EnumOptions == ModOptions.IGNORE_HEIGHTMAPS) {
            boolean bl = this.ignoreHeightmaps = !this.ignoreHeightmaps;
        }
        if (par1EnumOptions == ModOptions.OPEN_ANIMATION) {
            boolean bl = this.openMapAnimation = !this.openMapAnimation;
        }
        if (par1EnumOptions == ModOptions.RELOAD) {
            boolean bl = this.reloadEverything = !this.reloadEverything;
            if (this.reloadEverything) {
                ++this.reloadVersion;
            }
        }
        if (par1EnumOptions == ModOptions.ZOOM_BUTTONS) {
            boolean bl = this.zoomButtons = !this.zoomButtons;
        }
        if (par1EnumOptions == ModOptions.WAYPOINT_BACKGROUNDS) {
            boolean bl = this.waypointBackgrounds = !this.waypointBackgrounds;
        }
        if (par1EnumOptions == ModOptions.PAUSE_REQUESTS) {
            boolean bl = this.pauseRequests = !this.pauseRequests;
        }
        if (par1EnumOptions == ModOptions.EXTRA_DEBUG) {
            boolean bl = this.extraDebug = !this.extraDebug;
        }
        if (par1EnumOptions == ModOptions.UPDATE_NOTIFICATION) {
            updateNotification = !updateNotification;
        }
        this.updateRegionCacheHashCode();
        this.saveSettings();
        if (Minecraft.func_71410_x().field_71462_r != null) {
            Minecraft.func_71410_x().field_71462_r.func_146280_a(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71462_r.field_146294_l, Minecraft.func_71410_x().field_71462_r.field_146295_m);
        }
    }

    public void setOptionFloatValue(ModOptions options, float f) throws IOException {
        if (options == ModOptions.WAYPOINT_SCALE) {
            this.worldmapWaypointsScale = f;
        }
        this.saveSettings();
    }

    public float getOptionFloatValue(ModOptions options) {
        if (options == ModOptions.WAYPOINT_SCALE) {
            return this.worldmapWaypointsScale;
        }
        return 1.0f;
    }

    public int getRegionCacheHashCode() {
        return this.regionCacheHashCode;
    }

    public void updateRegionCacheHashCode() {
        int currentRegionCacheHashCode = this.regionCacheHashCode;
        if (!Minecraft.func_71410_x().func_152345_ab()) {
            throw new RuntimeException("Wrong thread!");
        }
        HashCodeBuilder hcb = new HashCodeBuilder();
        hcb.append(this.colours).append(this.terrainDepth).append(this.terrainSlopes).append(this.compression).append(this.colours == 1 && this.biomeColorsVanillaMode).append(this.ignoreHeightmaps);
        List enabledResourcePacks = Minecraft.func_71410_x().func_110438_M().func_110613_c();
        for (ResourcePackRepository.Entry resourcePack : enabledResourcePacks) {
            hcb.append((Object)resourcePack.func_110515_d());
        }
        this.regionCacheHashCode = hcb.toHashCode();
        if (currentRegionCacheHashCode != this.regionCacheHashCode) {
            System.out.println("New world map region cache hash code: " + this.regionCacheHashCode);
        }
    }

    static {
        updateNotification = true;
    }
}

